/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util;

import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.bool.BooleanVertex;
import io.improbable.keanu.vertices.bool.nonprobabilistic.BooleanIfVertex;
import io.improbable.keanu.vertices.bool.nonprobabilistic.operators.binary.AndBinaryVertex;
import io.improbable.keanu.vertices.bool.nonprobabilistic.operators.binary.BooleanBinaryOpVertex;
import io.improbable.keanu.vertices.bool.nonprobabilistic.operators.binary.OrBinaryVertex;
import io.improbable.keanu.vertices.bool.nonprobabilistic.operators.binary.compare.EqualsVertex;
import io.improbable.keanu.vertices.bool.nonprobabilistic.operators.binary.compare.GreaterThanOrEqualVertex;
import io.improbable.keanu.vertices.bool.nonprobabilistic.operators.binary.compare.GreaterThanVertex;
import io.improbable.keanu.vertices.bool.nonprobabilistic.operators.binary.compare.LessThanOrEqualVertex;
import io.improbable.keanu.vertices.bool.nonprobabilistic.operators.binary.compare.LessThanVertex;
import io.improbable.keanu.vertices.bool.nonprobabilistic.operators.binary.compare.NotEqualsVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.DoubleIfVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.operators.binary.AdditionVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.operators.binary.DifferenceVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.operators.binary.DivisionVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.operators.binary.MultiplicationVertex;
import io.improbable.keanu.vertices.intgr.nonprobabilistic.IntegerIfVertex;
import io.improbable.keanu.vertices.intgr.nonprobabilistic.operators.binary.IntegerAdditionVertex;
import io.improbable.keanu.vertices.intgr.nonprobabilistic.operators.binary.IntegerDifferenceVertex;
import io.improbable.keanu.vertices.intgr.nonprobabilistic.operators.binary.IntegerMultiplicationVertex;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class DescriptionCreator {
    private Map<Class, String> delimiters = new HashMap<Class, String>();
    private static final String thisVertex = "This Vertex";
    private static final String nullString = "Null";

    public DescriptionCreator() {
        this.delimiters.put(AdditionVertex.class, " + ");
        this.delimiters.put(IntegerAdditionVertex.class, " + ");
        this.delimiters.put(DifferenceVertex.class, " - ");
        this.delimiters.put(IntegerDifferenceVertex.class, " - ");
        this.delimiters.put(MultiplicationVertex.class, " * ");
        this.delimiters.put(IntegerMultiplicationVertex.class, " * ");
        this.delimiters.put(DivisionVertex.class, " / ");
        this.delimiters.put(AndBinaryVertex.class, " && ");
        this.delimiters.put(EqualsVertex.class, " == ");
        this.delimiters.put(GreaterThanOrEqualVertex.class, " >= ");
        this.delimiters.put(GreaterThanVertex.class, " > ");
        this.delimiters.put(LessThanOrEqualVertex.class, " <= ");
        this.delimiters.put(LessThanVertex.class, " < ");
        this.delimiters.put(NotEqualsVertex.class, " != ");
        this.delimiters.put(OrBinaryVertex.class, " || ");
    }

    public String createDescription(Vertex<?> vertex) {
        if (vertex == null) {
            return "This Vertex = Null";
        }
        Set<Vertex> parents = vertex.getParents();
        if (parents.size() == 0) {
            StringBuilder builder = new StringBuilder(thisVertex);
            builder.append(" = ");
            builder.append(DescriptionCreator.getLeafDescription(vertex));
            return builder.toString();
        }
        String thisLabel = vertex.getLabel() != null ? vertex.getLabel().toString() : thisVertex;
        return thisLabel + " = " + this.generateDescription(vertex, false, false);
    }

    private String generateDescription(Vertex<?> vertex, boolean allowLabels, boolean includeBrackets) {
        if (vertex == null) {
            return nullString;
        }
        if (allowLabels && vertex.getLabel() != null) {
            return vertex.getLabel().toString();
        }
        Set<Vertex> parents = vertex.getParents();
        if (parents.size() == 0) {
            return DescriptionCreator.getLeafDescription(vertex);
        }
        Optional<String> irregularDescription = this.checkForIrregularExpressions(vertex, includeBrackets);
        if (irregularDescription.isPresent()) {
            return irregularDescription.get();
        }
        if (this.delimiters.containsKey(vertex.getClass())) {
            CharSequence delimiter = this.delimiters.get(vertex.getClass());
            return this.getDelimiterVertexDescription(vertex, delimiter, includeBrackets);
        }
        Optional<String> saveLoadDescription = this.tryCreateDescriptionFromSaveLoadAnnotations(vertex, includeBrackets);
        return saveLoadDescription.orElseGet(() -> this.getDelimiterVertexDescription(vertex, ", ", includeBrackets));
    }

    private String getDelimiterVertexDescription(Vertex<?> vertex, CharSequence delimiter, boolean includeBrackets) {
        Stream<String> parentStream = vertex.getParents().stream().map(parent -> this.generateDescription((Vertex<?>)parent, true, true));
        CharSequence[] parentStrings = (String[])parentStream.toArray(String[]::new);
        StringBuilder builder = new StringBuilder();
        if (includeBrackets) {
            builder.append("(");
        }
        builder.append(String.join(delimiter, parentStrings));
        if (includeBrackets) {
            builder.append(")");
        }
        return builder.toString();
    }

    private static String getLeafDescription(Vertex<?> vertex) {
        if (vertex.getLabel() != null) {
            return vertex.getLabel().toString();
        }
        StringBuilder builder = new StringBuilder();
        Optional<String> scalarValue = DescriptionCreator.tryGetScalarValue(vertex);
        if (scalarValue.isPresent()) {
            builder.append("Const(");
            builder.append(scalarValue.get());
            builder.append(")");
        } else {
            builder.append(vertex.getClass().getSimpleName());
            builder.append(" with shape: ");
            builder.append(Arrays.toString(vertex.getShape()));
        }
        return builder.toString();
    }

    private static Optional<String> tryGetScalarValue(Vertex<?> vertex) {
        Tensor tensor = (Tensor)vertex.getValue();
        if (tensor.isScalar()) {
            return Optional.of(tensor.scalar().toString());
        }
        return Optional.empty();
    }

    private Optional<String> checkForIrregularExpressions(Vertex<?> vertex, boolean includeBrackets) {
        if (vertex instanceof BooleanIfVertex || vertex instanceof DoubleIfVertex || vertex instanceof IntegerIfVertex) {
            Optional<String> description = this.createIfStringDescription(vertex, includeBrackets);
            if (description.isPresent()) {
                return Optional.of(description.get());
            }
        } else if (vertex instanceof BooleanBinaryOpVertex) {
            String booleanBinaryDescription = this.createBooleanBinaryOpDescription((BooleanBinaryOpVertex)vertex, this.delimiters.getOrDefault(vertex.getClass(), ", "), includeBrackets);
            return Optional.of(booleanBinaryDescription);
        }
        return Optional.empty();
    }

    private Optional<String> createIfStringDescription(Vertex<?> vertex, boolean includeBrackets) {
        Vertex els;
        Vertex thn;
        BooleanVertex predicate;
        if (vertex instanceof IntegerIfVertex) {
            predicate = ((IntegerIfVertex)vertex).getPredicate();
            thn = ((IntegerIfVertex)vertex).getThn();
            els = ((IntegerIfVertex)vertex).getEls();
        } else if (vertex instanceof BooleanIfVertex) {
            predicate = ((BooleanIfVertex)vertex).getPredicate();
            thn = ((BooleanIfVertex)vertex).getThn();
            els = ((BooleanIfVertex)vertex).getEls();
        } else if (vertex instanceof DoubleIfVertex) {
            predicate = ((DoubleIfVertex)vertex).getPredicate();
            thn = ((DoubleIfVertex)vertex).getThn();
            els = ((DoubleIfVertex)vertex).getEls();
        } else {
            return Optional.empty();
        }
        StringBuilder builder = new StringBuilder();
        if (includeBrackets) {
            builder.append("(");
        }
        builder.append(this.generateDescription(predicate, true, true));
        builder.append(" ? ");
        builder.append(this.generateDescription(thn, true, true));
        builder.append(" : ");
        builder.append(this.generateDescription(els, true, true));
        if (includeBrackets) {
            builder.append(")");
        }
        return Optional.of(builder.toString());
    }

    private Optional<String> tryCreateDescriptionFromSaveLoadAnnotations(Vertex vertex, boolean includeBrackets) {
        Method[] classSaveLoadMethods = (Method[])Arrays.stream(vertex.getClass().getMethods()).filter(method -> method.isAnnotationPresent(SaveVertexParam.class)).toArray(Method[]::new);
        if (classSaveLoadMethods.length == 0) {
            return Optional.empty();
        }
        StringBuilder builder = new StringBuilder(includeBrackets ? "(" : "");
        String vertexName = vertex.getClass().getSimpleName();
        builder.append(vertexName);
        builder.append("(");
        try {
            for (Method method2 : classSaveLoadMethods) {
                String paramName = method2.getAnnotation(SaveVertexParam.class).value();
                Vertex paramVertex = (Vertex)method2.invoke((Object)vertex, new Object[0]);
                this.appendParamToBuilder(paramName, paramVertex, builder);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return Optional.empty();
        }
        builder.delete(builder.length() - 2, builder.length());
        return Optional.of(builder.append(")").append(includeBrackets ? ")" : "").toString());
    }

    private void appendParamToBuilder(String paramName, Vertex<?> paramVertex, StringBuilder builder) {
        builder.append(paramName).append("=");
        builder.append(this.generateDescription(paramVertex, true, true));
        builder.append(", ");
    }

    private String createBooleanBinaryOpDescription(BooleanBinaryOpVertex<?, ?> opVertex, String operation, boolean includeBrackets) {
        StringBuilder builder = new StringBuilder();
        if (includeBrackets) {
            builder.append("(");
        }
        builder.append(this.generateDescription(opVertex.getLeft(), true, includeBrackets));
        builder.append(operation);
        builder.append(this.generateDescription(opVertex.getRight(), true, includeBrackets));
        if (includeBrackets) {
            builder.append(")");
        }
        return builder.toString();
    }
}

