/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.validate.policy;

import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import io.improbable.keanu.tensor.validate.policy.TensorValidationPolicy;

public class ChangeValueTo<DATATYPE, TENSOR extends Tensor<DATATYPE, TENSOR>>
implements TensorValidationPolicy<DATATYPE, TENSOR> {
    private final DATATYPE value;

    ChangeValueTo(DATATYPE value) {
        this.value = value;
    }

    @Override
    public TENSOR handle(TENSOR tensor, BooleanTensor result) {
        if (tensor instanceof DoubleTensor) {
            Double value = (Double)this.value;
            DoubleTensor mask = result.not().toDoubleMask();
            tensor = ((DoubleTensor)tensor).setWithMask(mask, value);
        } else if (tensor instanceof IntegerTensor) {
            Integer value = (Integer)this.value;
            IntegerTensor mask = result.not().toIntegerMask();
            tensor = ((IntegerTensor)tensor).setWithMask(mask, value);
        } else {
            throw new ClassCastException("Cannot handle tensor of type " + tensor.getClass().getSimpleName());
        }
        return tensor;
    }
}

