/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.validate;

import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.tensor.validate.DebugTensorValidator;
import io.improbable.keanu.tensor.validate.NaNFixingTensorValidator;
import io.improbable.keanu.tensor.validate.TensorCheckAndRespondValidator;
import io.improbable.keanu.tensor.validate.check.CustomElementwiseTensorValueChecker;
import io.improbable.keanu.tensor.validate.check.CustomTensorValueChecker;
import io.improbable.keanu.tensor.validate.check.TensorValueChecker;
import io.improbable.keanu.tensor.validate.check.TensorValueNotEqualsCheck;
import io.improbable.keanu.tensor.validate.policy.TensorValidationPolicy;
import java.util.function.Function;

public interface TensorValidator<DATATYPE, TENSOR extends Tensor<DATATYPE, TENSOR>>
extends TensorValueChecker<DATATYPE, TENSOR> {
    public static final TensorValidator<Double, DoubleTensor> ZERO_CATCHER = TensorValidator.thatExpectsNotToFind(0.0);
    public static final DebugTensorValidator<Double, DoubleTensor> NAN_CATCHER = new DebugTensorValidator(TensorValidator.thatExpects(t -> t.notNaN()));
    public static final DebugTensorValidator<Double, DoubleTensor> NAN_FIXER = new DebugTensorValidator<Double, DoubleTensor>(new NaNFixingTensorValidator(0.0));

    public TENSOR validate(TENSOR var1);

    public static <DATATYPE, TENSOR extends Tensor<DATATYPE, TENSOR>> TensorCheckAndRespondValidator<DATATYPE, TENSOR> thatExpectsNotToFind(DATATYPE v) {
        return new TensorCheckAndRespondValidator(new TensorValueNotEqualsCheck(v));
    }

    public static <DATATYPE, TENSOR extends Tensor<DATATYPE, TENSOR>> TensorValidator<DATATYPE, TENSOR> thatReplaces(DATATYPE oldValue, DATATYPE newValue) {
        return new TensorCheckAndRespondValidator(new TensorValueNotEqualsCheck(oldValue), TensorValidationPolicy.changeValueTo(newValue));
    }

    public static <DATATYPE, TENSOR extends Tensor<DATATYPE, TENSOR>> TensorCheckAndRespondValidator<DATATYPE, TENSOR> thatExpects(Function<TENSOR, BooleanTensor> checkFunction) {
        return new TensorCheckAndRespondValidator(new CustomTensorValueChecker(checkFunction));
    }

    public static <DATATYPE, TENSOR extends Tensor<DATATYPE, TENSOR>> TensorCheckAndRespondValidator<DATATYPE, TENSOR> thatExpectsElementwise(Function<DATATYPE, Boolean> checkFunction) {
        return new TensorCheckAndRespondValidator(new CustomElementwiseTensorValueChecker(checkFunction));
    }

    public static <DATATYPE, TENSOR extends Tensor<DATATYPE, TENSOR>> TensorCheckAndRespondValidator<DATATYPE, TENSOR> thatFixesElementwise(Function<DATATYPE, Boolean> checkFunction, TensorValidationPolicy<DATATYPE, TENSOR> validationPolicy) {
        return new TensorCheckAndRespondValidator(new CustomElementwiseTensorValueChecker(checkFunction), validationPolicy);
    }
}

