/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.validate;

import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.tensor.validate.TensorValidator;

public class DebugTensorValidator<DATATYPE, TENSOR extends Tensor<DATATYPE, TENSOR>>
implements TensorValidator<DATATYPE, TENSOR> {
    private final TensorValidator<DATATYPE, TENSOR> delegate;
    private boolean debugMode = false;

    public DebugTensorValidator(TensorValidator<DATATYPE, TENSOR> delegate) {
        this.delegate = delegate;
    }

    @Override
    public TENSOR validate(TENSOR tensor) {
        if (this.debugMode) {
            return this.delegate.validate(tensor);
        }
        return tensor;
    }

    @Override
    public BooleanTensor check(TENSOR tensor) {
        if (this.debugMode) {
            return this.delegate.check(tensor);
        }
        return BooleanTensor.trues(tensor.getShape());
    }

    public void enable() {
        this.debugMode = true;
    }

    public void disable() {
        this.debugMode = false;
    }
}

