/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.ndj4;

import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.ops.random.impl.Linspace;
import org.nd4j.linalg.factory.Nd4j;

public class TypedINDArrayFactory {
    private static final DataType DEFAULT_FLOATING_POINT_TYPE = DataType.DOUBLE;

    public static INDArray create(double[] data, long[] shape) {
        Nd4j.setDefaultDataTypes((DataType)DataType.DOUBLE, (DataType)DEFAULT_FLOATING_POINT_TYPE);
        if (data.length == 0) {
            return Nd4j.empty((DataType)DataType.DOUBLE);
        }
        return Nd4j.createFromArray((double[])data).reshape(shape);
    }

    public static INDArray create(int[] data, long[] shape) {
        Nd4j.setDefaultDataTypes((DataType)DataType.INT, (DataType)DEFAULT_FLOATING_POINT_TYPE);
        if (data.length == 0) {
            return Nd4j.empty((DataType)DataType.INT);
        }
        return Nd4j.createFromArray((int[])data).reshape(shape);
    }

    public static INDArray ones(long[] shape, DataType bufferType) {
        Nd4j.setDefaultDataTypes((DataType)bufferType, (DataType)DEFAULT_FLOATING_POINT_TYPE);
        return Nd4j.ones((long[])shape);
    }

    public static INDArray eye(long n, DataType bufferType) {
        Nd4j.setDefaultDataTypes((DataType)bufferType, (DataType)DEFAULT_FLOATING_POINT_TYPE);
        return Nd4j.eye((long)n);
    }

    public static INDArray zeros(long[] shape, DataType bufferType) {
        Nd4j.setDefaultDataTypes((DataType)bufferType, (DataType)DEFAULT_FLOATING_POINT_TYPE);
        return Nd4j.zeros((long[])shape);
    }

    public static INDArray linspace(double start, double end, int numberOfPoints, DataType bufferType) {
        Nd4j.setDefaultDataTypes((DataType)bufferType, (DataType)DEFAULT_FLOATING_POINT_TYPE);
        return Nd4j.getExecutioner().exec((RandomOp)new Linspace(Nd4j.createUninitialized((long[])new long[]{numberOfPoints}, (char)Nd4j.order().charValue()), start, end));
    }

    public static INDArray arange(double start, double end) {
        Nd4j.setDefaultDataTypes((DataType)DataType.DOUBLE, (DataType)DEFAULT_FLOATING_POINT_TYPE);
        return Nd4j.arange((double)start, (double)end);
    }

    public static INDArray arange(int start, int end) {
        Nd4j.setDefaultDataTypes((DataType)DataType.INT, (DataType)DEFAULT_FLOATING_POINT_TYPE);
        return Nd4j.arange((double)start, (double)end);
    }
}

