/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.ndj4;

import io.improbable.keanu.tensor.FloatingPointTensor;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.tensor.dbl.TensorMulByMatrixMul;
import io.improbable.keanu.tensor.ndj4.INDArrayShim;
import io.improbable.keanu.tensor.ndj4.Nd4jNumberTensor;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.scalar.LogX;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.PowPairwise;
import org.nd4j.linalg.api.ops.impl.transforms.strict.ACosh;
import org.nd4j.linalg.api.ops.impl.transforms.strict.ASinh;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Expm1;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Log1p;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Tan;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.inverse.InvertMatrix;
import org.nd4j.linalg.ops.transforms.Transforms;

public abstract class Nd4jFloatingPointTensor<T extends Number, TENSOR extends FloatingPointTensor<T, TENSOR>>
extends Nd4jNumberTensor<T, TENSOR>
implements FloatingPointTensor<T, TENSOR> {
    public Nd4jFloatingPointTensor(INDArray tensor) {
        super(tensor);
    }

    @Override
    public TENSOR matrixInverse() {
        return (TENSOR)((FloatingPointTensor)this.create(InvertMatrix.invert((INDArray)this.tensor, (boolean)false)));
    }

    @Override
    public TENSOR choleskyDecomposition() {
        INDArray dup = this.tensor.dup();
        Nd4j.getBlasWrapper().lapack().potrf(dup, true);
        return (TENSOR)((FloatingPointTensor)this.create(dup));
    }

    @Override
    public TENSOR matrixMultiply(TENSOR value) {
        TensorShapeValidation.getMatrixMultiplicationResultingShape(this.tensor.shape(), value.getShape());
        INDArray mmulResult = this.tensor.mmul(this.getTensor(value));
        return (TENSOR)((FloatingPointTensor)this.create(mmulResult));
    }

    @Override
    public TENSOR tensorMultiply(TENSOR value, int[] dimsLeft, int[] dimsRight) {
        return (TENSOR)TensorMulByMatrixMul.tensorMmul((FloatingPointTensor)this.getThis(), value, dimsLeft, dimsRight);
    }

    @Override
    public TENSOR sqrtInPlace() {
        Transforms.sqrt((INDArray)this.tensor, (boolean)false);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR logInPlace() {
        Transforms.log((INDArray)this.tensor, (boolean)false);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR reciprocalInPlace() {
        this.tensor.rdivi((Number)1.0);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR sinInPlace() {
        Transforms.sin((INDArray)this.tensor, (boolean)false);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR cosInPlace() {
        Transforms.cos((INDArray)this.tensor, (boolean)false);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR tanInPlace() {
        Nd4j.getExecutioner().exec((Op)new Tan(this.tensor, this.tensor));
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR atanInPlace() {
        Transforms.atan((INDArray)this.tensor, (boolean)false);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR atan2InPlace(T y) {
        this.tensor = Transforms.atan2((INDArray)this.tensor, (INDArray)Nd4j.scalar(y).broadcast(this.tensor.shape()));
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR atan2InPlace(TENSOR y) {
        this.tensor = y.isScalar() ? Transforms.atan2((INDArray)this.tensor, (INDArray)this.getTensor(y).broadcast(this.tensor.shape())) : INDArrayShim.atan2(this.tensor, this.getTensor(y));
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR asinInPlace() {
        Transforms.asin((INDArray)this.tensor, (boolean)false);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR acosInPlace() {
        Transforms.acos((INDArray)this.tensor, (boolean)false);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR sinhInPlace() {
        Transforms.sinh((INDArray)this.tensor, (boolean)false);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR coshInPlace() {
        Transforms.cosh((INDArray)this.tensor, (boolean)false);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR tanhInPlace() {
        Transforms.tanh((INDArray)this.tensor, (boolean)false);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR asinhInPlace() {
        Nd4j.getExecutioner().execAndReturn((TransformOp)new ASinh(this.tensor));
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR acoshInPlace() {
        Nd4j.getExecutioner().execAndReturn((TransformOp)new ACosh(this.tensor));
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR atanhInPlace() {
        Transforms.atanh((INDArray)this.tensor, (boolean)false);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR expInPlace() {
        Transforms.exp((INDArray)this.tensor, (boolean)false);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR log1pInPlace() {
        Nd4j.getExecutioner().exec((Op)new Log1p(this.tensor));
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR log2InPlace() {
        Nd4j.getExecutioner().exec((ScalarOp)new LogX(this.tensor, 2.0));
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR log10InPlace() {
        Nd4j.getExecutioner().exec((ScalarOp)new LogX(this.tensor, 10.0));
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR exp2InPlace() {
        INDArray indArray = Nd4j.valueArrayOf((long[])this.tensor.shape(), (double)2.0);
        Nd4j.getExecutioner().exec((Op)new PowPairwise(indArray, this.tensor, this.tensor));
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR expM1InPlace() {
        Nd4j.getExecutioner().exec((Op)new Expm1(this.tensor));
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR standardizeInPlace() {
        this.tensor.subi(this.average()).divi(this.standardDeviation());
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR setAllInPlace(T value) {
        this.tensor.assign(value);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR clampInPlace(TENSOR min, TENSOR max) {
        return (TENSOR)((FloatingPointTensor)((FloatingPointTensor)this.minInPlace(max)).maxInPlace(min));
    }

    @Override
    public TENSOR ceilInPlace() {
        Transforms.ceil((INDArray)this.tensor, (boolean)false);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR floorInPlace() {
        Transforms.floor((INDArray)this.tensor, (boolean)false);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR roundInPlace() {
        Transforms.round((INDArray)this.tensor, (boolean)false);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public TENSOR sigmoidInPlace() {
        Transforms.sigmoid((INDArray)this.tensor, (boolean)false);
        return (TENSOR)((FloatingPointTensor)this.getThis());
    }

    @Override
    public T determinant() {
        INDArray dup = this.tensor.dup();
        double[][] asMatrix = dup.toDoubleMatrix();
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(asMatrix);
        return this.getNumber(new LUDecomposition((RealMatrix)matrix).getDeterminant());
    }

    @Override
    public T product() {
        return this.getNumber(this.tensor.prod(new int[0]).getNumber(0L));
    }

    @Override
    public BooleanTensor notNaN() {
        return this.elementwiseEquals(this);
    }
}

