/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.jvm;

import java.util.ArrayList;
import java.util.List;

public final class Slicer {
    private final List<StartStopStep> slices;

    private Slicer(List<StartStopStep> slices) {
        this.slices = slices;
    }

    public static SlicerBuilder builder() {
        return new SlicerBuilder();
    }

    public static Slicer fromString(String sliceArg) {
        String cleanSliceArg = sliceArg.replaceAll("\\s+", "");
        String[] byDimension = cleanSliceArg.split(",");
        SlicerBuilder slicerBuilder = Slicer.builder();
        for (String dimSlice : byDimension) {
            if (dimSlice.equals("...")) {
                slicerBuilder.all();
                continue;
            }
            String[] byColon = dimSlice.split(":", 3);
            if (byColon.length == 3) {
                slicerBuilder.slice(Slicer.parseStart(byColon[0]), Slicer.parseStop(byColon[1]), Slicer.parseStep(byColon[2]));
                continue;
            }
            if (byColon.length == 2) {
                slicerBuilder.slice(Slicer.parseStart(byColon[0]), Slicer.parseStop(byColon[1]));
                continue;
            }
            if (byColon.length == 1) {
                slicerBuilder.slice(Slicer.parseStart(byColon[0]));
                continue;
            }
            if (byColon.length == 0) {
                slicerBuilder.all();
                continue;
            }
            throw new IllegalArgumentException("Can not parse slice " + dimSlice);
        }
        return slicerBuilder.build();
    }

    private static Long parseStart(String arg) {
        return Slicer.getOrDefault(arg, 0L);
    }

    private static Long parseStop(String arg) {
        return Slicer.getOrDefault(arg, -1L);
    }

    private static Long parseStep(String arg) {
        return Slicer.getOrDefault(arg, 1L);
    }

    private static Long getOrDefault(String arg, long defaultValue) {
        try {
            return Long.parseLong(arg);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public List<StartStopStep> getSlices() {
        return this.slices;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Slicer)) {
            return false;
        }
        Slicer other = (Slicer)o;
        List<StartStopStep> this$slices = this.getSlices();
        List<StartStopStep> other$slices = other.getSlices();
        return !(this$slices == null ? other$slices != null : !((Object)this$slices).equals(other$slices));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<StartStopStep> $slices = this.getSlices();
        result = result * 59 + ($slices == null ? 43 : ((Object)$slices).hashCode());
        return result;
    }

    public String toString() {
        return "Slicer(slices=" + this.getSlices() + ")";
    }

    public static class SlicerBuilder {
        private ArrayList<StartStopStep> slices = new ArrayList();

        public SlicerBuilder slice(Long start, Long stop, Long step) {
            this.slices.add(new StartStopStep(start, stop, step));
            return this;
        }

        public SlicerBuilder slice(Integer start, Integer stop, Integer step) {
            this.slices.add(new StartStopStep(start, stop, step));
            return this;
        }

        public SlicerBuilder slice(Long start, Long stop) {
            this.slices.add(new StartStopStep(start, stop, 1L));
            return this;
        }

        public SlicerBuilder slice(Integer start, Integer stop) {
            this.slices.add(new StartStopStep(start, stop, 1));
            return this;
        }

        public SlicerBuilder slice(Long start) {
            this.slices.add(new StartStopStep(start, -2L, 1L));
            return this;
        }

        public SlicerBuilder slice(Integer start) {
            this.slices.add(new StartStopStep(start, -2, 1));
            return this;
        }

        public SlicerBuilder slice() {
            this.slices.add(StartStopStep.ALL);
            return this;
        }

        public SlicerBuilder all() {
            this.slices.add(StartStopStep.ALL);
            return this;
        }

        public Slicer build() {
            return new Slicer(this.slices);
        }
    }

    public static final class StartStopStep {
        public static final long DEFAULT_START = 0L;
        public static final long UPPER_BOUND_STOP = -1L;
        public static final long START_PLUS_ONE_STOP = -2L;
        public static final long DEFAULT_STEP = 1L;
        public static final StartStopStep ALL = new StartStopStep(0L, -1L, 1L);
        private final long start;
        private final long stop;
        private final long step;

        StartStopStep(Long start, Long stop, Long step) {
            this.start = start != null ? start : 0L;
            this.stop = stop != null ? stop : -1L;
            this.step = step != null ? step : 1L;
        }

        StartStopStep(Integer start, Integer stop, Integer step) {
            this.start = start != null ? (long)start.intValue() : 0L;
            this.stop = stop != null ? (long)stop.intValue() : -1L;
            this.step = step != null ? (long)step.intValue() : 1L;
        }

        public long getStart() {
            return this.start;
        }

        public long getStop() {
            return this.stop;
        }

        public long getStep() {
            return this.step;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StartStopStep)) {
                return false;
            }
            StartStopStep other = (StartStopStep)o;
            if (this.getStart() != other.getStart()) {
                return false;
            }
            if (this.getStop() != other.getStop()) {
                return false;
            }
            return this.getStep() == other.getStep();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $start = this.getStart();
            result = result * 59 + (int)($start >>> 32 ^ $start);
            long $stop = this.getStop();
            result = result * 59 + (int)($stop >>> 32 ^ $stop);
            long $step = this.getStep();
            result = result * 59 + (int)($step >>> 32 ^ $step);
            return result;
        }

        public String toString() {
            return "Slicer.StartStopStep(start=" + this.getStart() + ", stop=" + this.getStop() + ", step=" + this.getStep() + ")";
        }
    }
}

