/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.jvm;

import com.google.common.base.Preconditions;
import io.improbable.keanu.tensor.TensorShape;
import io.improbable.keanu.tensor.jvm.IndexMapper;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public final class DimensionIndexMapper
implements IndexMapper {
    private final int dimension;
    private final long index;
    private final long[] sourceShape;
    private final long[] sourceStride;
    private final long[] resultShape;
    private final long[] resultStride;

    public DimensionIndexMapper(long[] sourceShape, long[] sourceStride, int dimension, long index) {
        Preconditions.checkArgument((dimension < sourceShape.length && index < sourceShape[dimension] ? 1 : 0) != 0);
        this.dimension = dimension;
        this.index = index;
        this.sourceShape = sourceShape;
        this.sourceStride = sourceStride;
        this.resultShape = ArrayUtils.remove((long[])sourceShape, (int)dimension);
        this.resultStride = TensorShape.getRowFirstStride(this.resultShape);
    }

    @Override
    public long getSourceIndexFromResultIndex(long resultIndex) {
        long[] shapeIndices = ArrayUtils.insert((int)this.dimension, (long[])TensorShape.getShapeIndices(this.resultShape, this.resultStride, resultIndex), (long[])new long[]{this.index});
        return TensorShape.getFlatIndex(this.sourceShape, this.sourceStride, shapeIndices);
    }

    public int getDimension() {
        return this.dimension;
    }

    public long getIndex() {
        return this.index;
    }

    public long[] getSourceShape() {
        return this.sourceShape;
    }

    public long[] getSourceStride() {
        return this.sourceStride;
    }

    @Override
    public long[] getResultShape() {
        return this.resultShape;
    }

    @Override
    public long[] getResultStride() {
        return this.resultStride;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DimensionIndexMapper)) {
            return false;
        }
        DimensionIndexMapper other = (DimensionIndexMapper)o;
        if (this.getDimension() != other.getDimension()) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (!Arrays.equals(this.getSourceShape(), other.getSourceShape())) {
            return false;
        }
        if (!Arrays.equals(this.getSourceStride(), other.getSourceStride())) {
            return false;
        }
        if (!Arrays.equals(this.getResultShape(), other.getResultShape())) {
            return false;
        }
        return Arrays.equals(this.getResultStride(), other.getResultStride());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDimension();
        long $index = this.getIndex();
        result = result * 59 + (int)($index >>> 32 ^ $index);
        result = result * 59 + Arrays.hashCode(this.getSourceShape());
        result = result * 59 + Arrays.hashCode(this.getSourceStride());
        result = result * 59 + Arrays.hashCode(this.getResultShape());
        result = result * 59 + Arrays.hashCode(this.getResultStride());
        return result;
    }

    public String toString() {
        return "DimensionIndexMapper(dimension=" + this.getDimension() + ", index=" + this.getIndex() + ", sourceShape=" + Arrays.toString(this.getSourceShape()) + ", sourceStride=" + Arrays.toString(this.getSourceStride()) + ", resultShape=" + Arrays.toString(this.getResultShape()) + ", resultStride=" + Arrays.toString(this.getResultStride()) + ")";
    }
}

