/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.intgr;

import com.google.common.base.Preconditions;
import com.google.common.math.IntMath;
import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.TensorShape;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import io.improbable.keanu.tensor.jvm.Slicer;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;

public class ScalarIntegerTensor
implements IntegerTensor {
    private Integer value;
    private long[] shape;

    private ScalarIntegerTensor(Integer value, long[] shape) {
        this.value = value;
        this.shape = shape;
    }

    public ScalarIntegerTensor(int value) {
        this(value, SCALAR_SHAPE);
    }

    public ScalarIntegerTensor(long[] shape) {
        this(null, shape);
    }

    @Override
    public int getRank() {
        return this.shape.length;
    }

    @Override
    public long[] getShape() {
        return Arrays.copyOf(this.shape, this.shape.length);
    }

    @Override
    public long[] getStride() {
        return new long[this.shape.length];
    }

    @Override
    public long getLength() {
        return 1L;
    }

    @Override
    public IntegerTensor get(BooleanTensor booleanIndex) {
        return (Boolean)booleanIndex.scalar() != false ? IntegerTensor.scalar(this.value) : IntegerTensor.create(new int[0]);
    }

    @Override
    public IntegerTensor duplicate() {
        return new ScalarIntegerTensor(this.value, this.shape);
    }

    @Override
    public Integer sum() {
        return this.value;
    }

    @Override
    public DoubleTensor toDouble() {
        return DoubleTensor.create((double)this.value.intValue(), this.shape);
    }

    @Override
    public IntegerTensor toInteger() {
        return this;
    }

    @Override
    public Integer scalar() {
        return this.value;
    }

    @Override
    public IntegerTensor reshape(long ... newShape) {
        if (TensorShape.getLength(newShape) != 1L) {
            throw new IllegalArgumentException("Cannot reshape scalar to non scalar");
        }
        return new ScalarIntegerTensor(this.value, newShape);
    }

    @Override
    public IntegerTensor permute(int ... rearrange) {
        if (rearrange.length > this.shape.length) {
            throw new IllegalArgumentException("Cannot permute " + Arrays.toString(rearrange) + " on shape " + Arrays.toString(this.shape));
        }
        return new ScalarIntegerTensor(this.value, this.shape);
    }

    @Override
    public IntegerTensor broadcast(long ... toShape) {
        int bufferLength = TensorShape.getLengthAsInt(toShape);
        int[] buffer = new int[bufferLength];
        Arrays.fill(buffer, this.value);
        return IntegerTensor.create(buffer, toShape);
    }

    @Override
    public IntegerTensor diag() {
        return this.duplicate();
    }

    @Override
    public IntegerTensor transpose() {
        return this.duplicate();
    }

    @Override
    public IntegerTensor sum(int ... overDimensions) {
        overDimensions = TensorShape.setToAbsoluteDimensions(this.shape.length, overDimensions);
        long[] summedShape = ArrayUtils.removeAll((long[])this.shape, (int[])overDimensions);
        return new ScalarIntegerTensor(this.value, summedShape);
    }

    @Override
    public IntegerTensor cumSumInPlace(int dimension) {
        return this;
    }

    @Override
    public Integer product() {
        return this.value;
    }

    @Override
    public IntegerTensor product(int ... overDimensions) {
        return this;
    }

    @Override
    public IntegerTensor cumProdInPlace(int dimension) {
        return this;
    }

    @Override
    public boolean equalsWithinEpsilon(IntegerTensor other, Integer epsilon) {
        if (other instanceof ScalarIntegerTensor) {
            return Math.abs((Integer)other.scalar() - this.value) < epsilon;
        }
        return other.equalsWithinEpsilon(this, epsilon);
    }

    @Override
    public IntegerTensor matrixMultiply(IntegerTensor that) {
        if (that.isLengthOne()) {
            return (IntegerTensor)((Object)that.times(this.value));
        }
        throw new IllegalArgumentException("Cannot use matrix multiply with scalar. Use times instead.");
    }

    @Override
    public IntegerTensor tensorMultiply(IntegerTensor that, int[] dimsLeft, int[] dimsRight) {
        if (that.isLengthOne()) {
            if (dimsLeft.length > 1 || dimsRight.length > 1 || dimsLeft[0] != 0 || dimsRight[0] != 0) {
                throw new IllegalArgumentException("Tensor multiply sum dimensions out of bounds for scalar");
            }
            return (IntegerTensor)((Object)that.times(this.value));
        }
        throw new IllegalArgumentException("Cannot use tensor multiply with scalar. Use times instead.");
    }

    @Override
    public IntegerTensor greaterThanMask(IntegerTensor greaterThanThis) {
        if (greaterThanThis.isLengthOne()) {
            long[] newShape = TensorShape.calculateShapeForLengthOneBroadcast(this.shape, greaterThanThis.getShape());
            return new ScalarIntegerTensor(this.value > (Integer)greaterThanThis.scalar() ? 1 : 0, newShape);
        }
        return IntegerTensor.create((int)this.value, greaterThanThis.getShape()).greaterThanMask(greaterThanThis);
    }

    @Override
    public IntegerTensor greaterThanOrEqualToMask(IntegerTensor greaterThanOrEqualToThis) {
        if (greaterThanOrEqualToThis.isLengthOne()) {
            long[] newShape = TensorShape.calculateShapeForLengthOneBroadcast(this.shape, greaterThanOrEqualToThis.getShape());
            return new ScalarIntegerTensor(this.value >= (Integer)greaterThanOrEqualToThis.scalar() ? 1 : 0, newShape);
        }
        return IntegerTensor.create((int)this.value, greaterThanOrEqualToThis.getShape()).greaterThanOrEqualToMask(greaterThanOrEqualToThis);
    }

    @Override
    public IntegerTensor lessThanMask(IntegerTensor lessThanThis) {
        if (lessThanThis.isLengthOne()) {
            long[] newShape = TensorShape.calculateShapeForLengthOneBroadcast(this.shape, lessThanThis.getShape());
            return new ScalarIntegerTensor(this.value < (Integer)lessThanThis.scalar() ? 1 : 0, newShape);
        }
        return IntegerTensor.create((int)this.value, lessThanThis.getShape()).lessThanMask(lessThanThis);
    }

    @Override
    public IntegerTensor lessThanOrEqualToMask(IntegerTensor lessThanOrEqualsThis) {
        if (lessThanOrEqualsThis.isLengthOne()) {
            long[] newShape = TensorShape.calculateShapeForLengthOneBroadcast(this.shape, lessThanOrEqualsThis.getShape());
            return new ScalarIntegerTensor(this.value <= (Integer)lessThanOrEqualsThis.scalar() ? 1 : 0, newShape);
        }
        return IntegerTensor.create((int)this.value, lessThanOrEqualsThis.getShape()).lessThanOrEqualToMask(lessThanOrEqualsThis);
    }

    @Override
    public IntegerTensor setWithMaskInPlace(IntegerTensor withMask, Integer valueToApply) {
        if (!withMask.isLengthOne()) {
            return IntegerTensor.create((int)this.value, withMask.getShape()).setWithMaskInPlace(withMask, valueToApply);
        }
        this.value = (double)((Integer)withMask.scalar()).intValue() == 1.0 ? valueToApply : this.value;
        return this;
    }

    @Override
    public IntegerTensor slice(int dimension, long index) {
        if (dimension == 0 && index == 0L) {
            return this.duplicate();
        }
        throw new IllegalStateException("Slice is only valid for dimension and index zero in a scalar");
    }

    @Override
    public IntegerTensor slice(Slicer slicer) {
        return this.slice(0, 0L);
    }

    @Override
    public IntegerTensor take(long ... index) {
        return new ScalarIntegerTensor((Integer)this.getValue(index));
    }

    @Override
    public List<IntegerTensor> split(int dimension, long ... splitAtIndices) {
        throw new UnsupportedOperationException("Cannot split scalar!");
    }

    @Override
    public IntegerTensor minusInPlace(Integer that) {
        this.value = this.value - that;
        return this;
    }

    @Override
    public IntegerTensor plusInPlace(Integer that) {
        this.value = this.value + that;
        return this;
    }

    @Override
    public IntegerTensor timesInPlace(Integer that) {
        this.value = this.value * that;
        return this;
    }

    @Override
    public IntegerTensor divInPlace(Integer that) {
        this.value = this.value / that;
        return this;
    }

    @Override
    public IntegerTensor powInPlace(IntegerTensor exponent) {
        if (!exponent.isLengthOne()) {
            return (IntegerTensor)IntegerTensor.create((int)this.value, exponent.getShape()).powInPlace(exponent);
        }
        this.powInPlace((Integer)exponent.scalar());
        this.shape = TensorShape.calculateShapeForLengthOneBroadcast(this.shape, exponent.getShape());
        return this;
    }

    @Override
    public IntegerTensor powInPlace(Integer exponent) {
        this.value = IntMath.pow((int)this.value, (int)exponent);
        return this;
    }

    @Override
    public Integer average() {
        return this.value;
    }

    @Override
    public Integer standardDeviation() {
        return 0;
    }

    @Override
    public IntegerTensor minusInPlace(IntegerTensor that) {
        if (!that.isLengthOne()) {
            return IntegerTensor.create((int)this.value, that.getShape()).minusInPlace(that);
        }
        this.minusInPlace((Integer)that.scalar());
        this.shape = TensorShape.calculateShapeForLengthOneBroadcast(this.shape, that.getShape());
        return this;
    }

    @Override
    public IntegerTensor reverseMinusInPlace(IntegerTensor value) {
        if (value instanceof ScalarIntegerTensor) {
            return this.reverseMinusInPlace((Integer)value.scalar());
        }
        return (IntegerTensor)((Object)value.minus(this.value));
    }

    @Override
    public IntegerTensor reverseMinusInPlace(Integer value) {
        this.value = value - this.value;
        return this;
    }

    @Override
    public IntegerTensor plusInPlace(IntegerTensor that) {
        if (!that.isLengthOne()) {
            return IntegerTensor.create((int)this.value, that.getShape()).plusInPlace(that);
        }
        this.plusInPlace((Integer)that.scalar());
        this.shape = TensorShape.calculateShapeForLengthOneBroadcast(this.shape, that.getShape());
        return this;
    }

    @Override
    public IntegerTensor timesInPlace(IntegerTensor that) {
        if (!that.isLengthOne()) {
            return IntegerTensor.create((int)this.value, that.getShape()).timesInPlace(that);
        }
        this.timesInPlace((Integer)that.scalar());
        this.shape = TensorShape.calculateShapeForLengthOneBroadcast(this.shape, that.getShape());
        return this;
    }

    @Override
    public IntegerTensor divInPlace(IntegerTensor that) {
        if (!that.isLengthOne()) {
            return IntegerTensor.create((int)this.value, that.getShape()).divInPlace(that);
        }
        this.divInPlace((Integer)that.scalar());
        this.shape = TensorShape.calculateShapeForLengthOneBroadcast(this.shape, that.getShape());
        return this;
    }

    @Override
    public IntegerTensor reverseDivInPlace(Integer value) {
        this.value = value / this.value;
        return this;
    }

    @Override
    public IntegerTensor reverseDivInPlace(IntegerTensor value) {
        if (value instanceof ScalarIntegerTensor) {
            return this.reverseDivInPlace((Integer)value.scalar());
        }
        return (IntegerTensor)((Object)value.div(this.value));
    }

    @Override
    public IntegerTensor unaryMinusInPlace() {
        this.value = -this.value.intValue();
        return this;
    }

    @Override
    public IntegerTensor absInPlace() {
        this.value = Math.abs(this.value);
        return this;
    }

    @Override
    public IntegerTensor applyInPlace(Function<Integer, Integer> function) {
        this.value = function.apply(this.value);
        return this;
    }

    @Override
    public IntegerTensor setAllInPlace(Integer value) {
        this.value = value;
        return this;
    }

    @Override
    public IntegerTensor safeLogTimesInPlace(IntegerTensor y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BooleanTensor lessThan(Integer that) {
        return BooleanTensor.create(this.value < that, this.shape);
    }

    @Override
    public BooleanTensor lessThanOrEqual(Integer that) {
        return BooleanTensor.create(this.value <= that, this.shape);
    }

    @Override
    public BooleanTensor lessThan(IntegerTensor that) {
        if (that.isLengthOne()) {
            long[] newShape = TensorShape.calculateShapeForLengthOneBroadcast(this.shape, that.getShape());
            return BooleanTensor.create(this.value < (Integer)that.scalar(), newShape);
        }
        return that.greaterThan(this.value);
    }

    @Override
    public BooleanTensor lessThanOrEqual(IntegerTensor that) {
        if (that.isLengthOne()) {
            long[] newShape = TensorShape.calculateShapeForLengthOneBroadcast(this.shape, that.getShape());
            return BooleanTensor.create(this.value <= (Integer)that.scalar(), newShape);
        }
        return that.greaterThanOrEqual(this.value);
    }

    @Override
    public BooleanTensor greaterThan(Integer value) {
        return BooleanTensor.create(this.value > value, this.shape);
    }

    @Override
    public BooleanTensor greaterThanOrEqual(Integer value) {
        return BooleanTensor.create(this.value >= value, this.shape);
    }

    @Override
    public IntegerTensor minInPlace(IntegerTensor min) {
        if (min.isLengthOne()) {
            long[] newShape = TensorShape.calculateShapeForLengthOneBroadcast(this.shape, min.getShape());
            return new ScalarIntegerTensor(Math.min(this.value, (Integer)min.scalar()), newShape);
        }
        return ((IntegerTensor)min.duplicate()).minInPlace(this);
    }

    @Override
    public IntegerTensor clampInPlace(IntegerTensor min, IntegerTensor max) {
        Preconditions.checkArgument((min.isScalar() && max.isScalar() ? 1 : 0) != 0);
        return new ScalarIntegerTensor(Math.max(Math.min(this.value, (Integer)max.scalar()), (Integer)min.scalar()), this.shape);
    }

    @Override
    public IntegerTensor maxInPlace(IntegerTensor max) {
        if (max.isLengthOne()) {
            long[] newShape = TensorShape.calculateShapeForLengthOneBroadcast(this.shape, max.getShape());
            return new ScalarIntegerTensor(Math.max(this.value, (Integer)max.scalar()), newShape);
        }
        return ((IntegerTensor)max.duplicate()).maxInPlace(this);
    }

    @Override
    public Integer min() {
        return this.value;
    }

    @Override
    public Integer max() {
        return this.value;
    }

    @Override
    public int argMax() {
        return 0;
    }

    @Override
    public IntegerTensor argMax(int axis) {
        TensorShapeValidation.checkDimensionExistsInShape(axis, this.getShape());
        return IntegerTensor.scalar(0);
    }

    @Override
    public int argMin() {
        return 0;
    }

    @Override
    public IntegerTensor argMin(int axis) {
        TensorShapeValidation.checkDimensionExistsInShape(axis, this.getShape());
        return IntegerTensor.scalar(0);
    }

    @Override
    public BooleanTensor greaterThan(IntegerTensor that) {
        if (that.isLengthOne()) {
            long[] newShape = TensorShape.calculateShapeForLengthOneBroadcast(this.shape, that.getShape());
            return BooleanTensor.create(this.value > (Integer)that.scalar(), newShape);
        }
        return that.lessThan(this.value);
    }

    @Override
    public BooleanTensor greaterThanOrEqual(IntegerTensor that) {
        if (that.isLengthOne()) {
            long[] newShape = TensorShape.calculateShapeForLengthOneBroadcast(this.shape, that.getShape());
            return BooleanTensor.create(this.value >= (Integer)that.scalar(), newShape);
        }
        return that.lessThanOrEqual(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tensor)) {
            return false;
        }
        Tensor that = (Tensor)o;
        if (!Arrays.equals(that.getShape(), this.shape)) {
            return false;
        }
        return that.scalar().equals(this.value);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.shape);
        return result;
    }

    @Override
    public Tensor.FlattenedView<Integer> getFlattenedView() {
        return new SimpleIntegerFlattenedView();
    }

    @Override
    public BooleanTensor elementwiseEquals(Tensor that) {
        if (that instanceof IntegerTensor) {
            IntegerTensor thatAsInteger = (IntegerTensor)that;
            if (that.isLengthOne()) {
                long[] newShape = TensorShape.calculateShapeForLengthOneBroadcast(this.shape, that.getShape());
                return BooleanTensor.create(this.value.equals(thatAsInteger.scalar()), newShape);
            }
            return thatAsInteger.elementwiseEquals(this.value);
        }
        return Tensor.elementwiseEquals(this, that);
    }

    @Override
    public BooleanTensor elementwiseEquals(Integer value) {
        return BooleanTensor.create(this.scalar().equals(value), this.shape);
    }

    @Override
    public double[] asFlatDoubleArray() {
        return new double[]{this.value.intValue()};
    }

    @Override
    public int[] asFlatIntegerArray() {
        return new int[]{this.value};
    }

    public Integer[] asFlatArray() {
        return new Integer[]{this.value};
    }

    public String toString() {
        return "ScalarIntegerTensor{value=" + this.value + '}';
    }

    @Override
    public IntegerTensor modInPlace(Integer that) {
        this.value = this.value % that;
        return this;
    }

    @Override
    public IntegerTensor modInPlace(IntegerTensor that) {
        Preconditions.checkArgument((boolean)that.isScalar());
        return this.modInPlace((Integer)that.scalar());
    }

    private class SimpleIntegerFlattenedView
    implements Tensor.FlattenedView<Integer> {
        private SimpleIntegerFlattenedView() {
        }

        @Override
        public long size() {
            return 1L;
        }

        @Override
        public Integer get(long index) {
            if (index != 0L) {
                throw new IndexOutOfBoundsException();
            }
            return ScalarIntegerTensor.this.value;
        }

        @Override
        public Integer getOrScalar(long index) {
            return ScalarIntegerTensor.this.value;
        }

        @Override
        public void set(long index, Integer value) {
            if (index != 0L) {
                throw new IndexOutOfBoundsException();
            }
            ScalarIntegerTensor.this.value = value;
        }
    }
}

