/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.generic;

import com.google.common.primitives.Ints;
import io.improbable.keanu.tensor.buffer.JVMBuffer;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;

public class GenericBuffer {

    public static final class GenericWrapper<T>
    extends JVMBuffer.SingleValueWrapper<T, PrimitiveGenericWrapper<T>>
    implements PrimitiveGenericWrapper<T> {
        public GenericWrapper(T value) {
            super(value);
        }

        @Override
        protected PrimitiveGenericWrapper<T> getThis() {
            return this;
        }

        @Override
        public PrimitiveGenericWrapper<T> copy() {
            return new GenericWrapper<Object>(this.value);
        }

        @Override
        public T[] asArray() {
            return new Object[]{this.value};
        }
    }

    public static final class GenericArrayWrapper<T>
    implements PrimitiveGenericWrapper<T> {
        private final T[] array;

        public GenericArrayWrapper(T[] array) {
            this.array = array;
        }

        @Override
        public T get(long index) {
            return this.array[Ints.checkedCast((long)index)];
        }

        @Override
        public GenericArrayWrapper<T> set(T value, long index) {
            this.array[Ints.checkedCast((long)index)] = value;
            return this;
        }

        @Override
        public long getLength() {
            return this.array.length;
        }

        @Override
        public PrimitiveGenericWrapper<T> copy() {
            return new GenericArrayWrapper<T>(Arrays.copyOf(this.array, this.array.length));
        }

        @Override
        public GenericArrayWrapper<T> copyFrom(JVMBuffer.PrimitiveArrayWrapper<T, ?> src, long srcPos, long destPos, long length) {
            if (src instanceof GenericArrayWrapper) {
                System.arraycopy(((GenericArrayWrapper)src).array, Ints.checkedCast((long)srcPos), this.array, Ints.checkedCast((long)destPos), Ints.checkedCast((long)length));
            } else {
                int i = 0;
                while ((long)i < length) {
                    this.array[Ints.checkedCast((long)(destPos + (long)i))] = src.get(srcPos + (long)i);
                    ++i;
                }
            }
            return this;
        }

        @Override
        public T[] asArray() {
            return this.array;
        }

        @Override
        public GenericArrayWrapper<T> applyRight(BiFunction<T, T, T> mapper, T rightArg) {
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = mapper.apply(this.array[i], rightArg);
            }
            return this;
        }

        @Override
        public GenericArrayWrapper<T> applyLeft(BiFunction<T, T, T> mapper, T leftArg) {
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = mapper.apply(leftArg, this.array[i]);
            }
            return this;
        }

        @Override
        public GenericArrayWrapper<T> apply(Function<T, T> mapper) {
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = mapper.apply(this.array[i]);
            }
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrimitiveGenericWrapper)) {
                return false;
            }
            PrimitiveGenericWrapper other = (PrimitiveGenericWrapper)o;
            return Arrays.equals(this.array, other.asArray());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.array);
            return result;
        }
    }

    public static interface PrimitiveGenericWrapper<T>
    extends JVMBuffer.PrimitiveArrayWrapper<T, PrimitiveGenericWrapper<T>> {
        @Override
        public T[] asArray();
    }

    public static final class GenericArrayWrapperFactory<T>
    implements JVMBuffer.ArrayWrapperFactory<T, PrimitiveGenericWrapper<T>> {
        @Override
        public final PrimitiveGenericWrapper<T> createNew(long size) {
            if (size == 1L) {
                return new GenericWrapper<Object>(null);
            }
            return new GenericArrayWrapper<Object>(new Object[Ints.checkedCast((long)size)]);
        }

        @Override
        public PrimitiveGenericWrapper<T> createNew(T value) {
            return new GenericWrapper<T>(value);
        }

        public final PrimitiveGenericWrapper<T> create(T[] data) {
            if (data.length == 1) {
                return new GenericWrapper<T>(data[0]);
            }
            return new GenericArrayWrapper<T>(data);
        }
    }
}

