/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.dbl;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.improbable.keanu.tensor.NumberTensor;
import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.TensorShape;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.tensor.dbl.BroadcastableDoubleOperations;
import io.improbable.keanu.tensor.dbl.DoubleBuffer;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.tensor.dbl.KeanuLapack;
import io.improbable.keanu.tensor.dbl.TensorMulByMatrixMul;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import io.improbable.keanu.tensor.jvm.JVMFloatingPointTensor;
import io.improbable.keanu.tensor.jvm.JVMTensor;
import io.improbable.keanu.tensor.jvm.ResultWrapper;
import io.improbable.keanu.tensor.validate.TensorValidator;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.math3.analysis.function.Sigmoid;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.util.FastMath;
import org.bytedeco.openblas.global.openblas;

public class JVMDoubleTensor
extends JVMFloatingPointTensor<Double, DoubleTensor, DoubleBuffer.PrimitiveDoubleWrapper>
implements DoubleTensor {
    private static final DoubleBuffer.DoubleArrayWrapperFactory factory = new DoubleBuffer.DoubleArrayWrapperFactory();
    private static final Sigmoid sigmoid = new Sigmoid();

    private JVMDoubleTensor(DoubleBuffer.PrimitiveDoubleWrapper buffer, long[] shape, long[] stride) {
        super(buffer, shape, stride);
    }

    private JVMDoubleTensor(DoubleBuffer.PrimitiveDoubleWrapper buffer, long[] shape) {
        super(buffer, shape, TensorShape.getRowFirstStride(shape));
    }

    private JVMDoubleTensor(ResultWrapper<Double, DoubleBuffer.PrimitiveDoubleWrapper> resultWrapper) {
        this((DoubleBuffer.PrimitiveDoubleWrapper)resultWrapper.outputBuffer, resultWrapper.outputShape, resultWrapper.outputStride);
    }

    private JVMDoubleTensor(double[] data, long[] shape, long[] stride) {
        this(factory.create(data), shape, stride);
    }

    private JVMDoubleTensor(double[] data, long[] shape) {
        this(factory.create(data), shape);
    }

    private JVMDoubleTensor(double value) {
        super(new DoubleBuffer.DoubleWrapper(value), new long[0], new long[0]);
    }

    @Override
    protected DoubleTensor create(DoubleBuffer.PrimitiveDoubleWrapper buffer, long[] shape, long[] stride) {
        return new JVMDoubleTensor(buffer, shape, stride);
    }

    @Override
    protected DoubleTensor set(DoubleBuffer.PrimitiveDoubleWrapper buffer, long[] shape, long[] stride) {
        this.buffer = buffer;
        this.shape = shape;
        this.stride = stride;
        return this;
    }

    @Override
    protected DoubleBuffer.DoubleArrayWrapperFactory getFactory() {
        return factory;
    }

    public static JVMDoubleTensor scalar(double scalarValue) {
        return new JVMDoubleTensor(scalarValue);
    }

    public static JVMDoubleTensor create(double[] values, long ... shape) {
        if ((long)values.length != TensorShape.getLength(shape)) {
            throw new IllegalArgumentException("Shape " + Arrays.toString(shape) + " does not match buffer size " + values.length);
        }
        return new JVMDoubleTensor(values, shape);
    }

    public static JVMDoubleTensor create(double value, long ... shape) {
        int length = TensorShape.getLengthAsInt(shape);
        if (length > 1) {
            double[] buffer = new double[length];
            if (value != 0.0) {
                Arrays.fill(buffer, value);
            }
            return new JVMDoubleTensor(buffer, shape);
        }
        return new JVMDoubleTensor(new DoubleBuffer.DoubleWrapper(value), shape);
    }

    public static JVMDoubleTensor ones(long ... shape) {
        return JVMDoubleTensor.create(1.0, shape);
    }

    public static JVMDoubleTensor zeros(long ... shape) {
        return JVMDoubleTensor.create(0.0, shape);
    }

    public static JVMDoubleTensor eye(long n) {
        if (n == 1L) {
            return JVMDoubleTensor.create(1.0, 1L, 1L);
        }
        double[] buffer = new double[Ints.checkedCast((long)(n * n))];
        int nInt = Ints.checkedCast((long)n);
        int i = 0;
        while ((long)i < n) {
            buffer[i * nInt + i] = 1.0;
            ++i;
        }
        return new JVMDoubleTensor(buffer, new long[]{n, n});
    }

    public static JVMDoubleTensor arange(double start, double end) {
        return JVMDoubleTensor.arange(start, end, 1.0);
    }

    public static JVMDoubleTensor arange(double start, double end, double stepSize) {
        Preconditions.checkArgument((stepSize != 0.0 ? 1 : 0) != 0);
        int steps = (int)Math.ceil((end - start) / stepSize);
        return JVMDoubleTensor.linearBufferCreate(start, steps, stepSize);
    }

    public static JVMDoubleTensor linspace(double start, double end, int numberOfPoints) {
        Preconditions.checkArgument((numberOfPoints > 0 ? 1 : 0) != 0);
        double stepSize = (end - start) / (double)(numberOfPoints - 1);
        return JVMDoubleTensor.linearBufferCreate(start, numberOfPoints, stepSize);
    }

    private static JVMDoubleTensor linearBufferCreate(double start, int numberOfPoints, double stepSize) {
        Preconditions.checkArgument((numberOfPoints > 0 ? 1 : 0) != 0);
        double[] buffer = new double[numberOfPoints];
        double currentValue = start;
        int i = 0;
        while (i < buffer.length) {
            buffer[i] = currentValue;
            ++i;
            currentValue += stepSize;
        }
        return new JVMDoubleTensor(buffer, new long[]{buffer.length});
    }

    private long[] shapeCopy() {
        return Arrays.copyOf(this.shape, this.shape.length);
    }

    @Override
    public BooleanTensor elementwiseEquals(Tensor that) {
        if (that instanceof DoubleTensor) {
            if (this.isScalar()) {
                return that.elementwiseEquals(this.scalar());
            }
            if (that.isScalar()) {
                return this.elementwiseEquals((Double)((DoubleTensor)that).scalar());
            }
            DoubleTensor equalsMask = this.duplicate().broadcastableBinaryOpWithAutoBroadcast((l, r) -> l.doubleValue() == r.doubleValue() ? 1.0 : 0.0, JVMDoubleTensor.getAsJVMTensor((DoubleTensor)that));
            return this.maskToBooleanTensor(equalsMask);
        }
        return Tensor.elementwiseEquals(this, that);
    }

    @Override
    public BooleanTensor elementwiseEquals(Double value) {
        boolean[] newBuffer = new boolean[Ints.checkedCast((long)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength())];
        int i = 0;
        while ((long)i < ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength()) {
            newBuffer[i] = value.doubleValue() == ((Double)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(i)).doubleValue();
            ++i;
        }
        return BooleanTensor.create(newBuffer, this.shapeCopy());
    }

    @Override
    public JVMDoubleTensor duplicate() {
        return new JVMDoubleTensor((DoubleBuffer.PrimitiveDoubleWrapper)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).copy(), this.shapeCopy(), Arrays.copyOf(this.stride, this.stride.length));
    }

    @Override
    public DoubleTensor toDouble() {
        return this.duplicate();
    }

    @Override
    public IntegerTensor toInteger() {
        return IntegerTensor.create(((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).asIntegerArray(), this.shapeCopy());
    }

    @Override
    public DoubleTensor choleskyDecomposition() {
        double[] newBuffer;
        if (this.shape.length != 2 || this.shape[0] != this.shape[1]) {
            throw new IllegalArgumentException("Cholesky decomposition must be performed on square matrix.");
        }
        int N = Ints.checkedCast((long)this.shape[0]);
        int result = KeanuLapack.dpotrf(KeanuLapack.Triangular.LOWER, N, newBuffer = ((DoubleBuffer.PrimitiveDoubleWrapper)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).copy()).asDoubleArray());
        if (result != 0) {
            throw new IllegalStateException("Cholesky decomposition failed");
        }
        this.zeroOutUpperTriangle(N, newBuffer);
        return new JVMDoubleTensor(newBuffer, this.shapeCopy());
    }

    private void zeroOutUpperTriangle(int N, double[] buffer) {
        if (N > 1) {
            for (int i = 0; i < N; ++i) {
                for (int j = i + 1; j < N; ++j) {
                    buffer[i * N + j] = 0.0;
                }
            }
        }
    }

    @Override
    public Double determinant() {
        int[] ipiv;
        double[] newBuffer;
        int n;
        int m = Ints.checkedCast((long)this.shape[0]);
        int factorizationResult = KeanuLapack.dgetrf(m, n = Ints.checkedCast((long)this.shape[1]), newBuffer = ((DoubleBuffer.PrimitiveDoubleWrapper)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).copy()).asDoubleArray(), ipiv = new int[newBuffer.length]);
        if (factorizationResult < 0) {
            throw new IllegalStateException("Matrix factorization failed");
        }
        if (factorizationResult > 0) {
            return 0.0;
        }
        double detp = 1.0;
        for (int j = 0; j < n; ++j) {
            if (j + 1 == ipiv[j]) continue;
            detp = -detp;
        }
        double detU = 1.0;
        for (int i = 0; i < m; ++i) {
            detU *= newBuffer[i * m + i];
        }
        return detU * detp;
    }

    @Override
    public DoubleTensor matrixInverse() {
        int[] ipiv;
        double[] newBuffer;
        int n;
        int m = Ints.checkedCast((long)this.shape[0]);
        int factorizationResult = KeanuLapack.dgetrf(m, n = Ints.checkedCast((long)this.shape[1]), newBuffer = ((DoubleBuffer.PrimitiveDoubleWrapper)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).copy()).asDoubleArray(), ipiv = new int[newBuffer.length]);
        if (factorizationResult < 0) {
            throw new IllegalStateException("Matrix factorization failed");
        }
        if (factorizationResult > 0) {
            throw new SingularMatrixException();
        }
        int inverseResult = KeanuLapack.dgetri(m, newBuffer, ipiv);
        if (inverseResult != 0) {
            throw new IllegalStateException("Matrix inverse failed");
        }
        return new JVMDoubleTensor(newBuffer, this.shapeCopy());
    }

    @Override
    public DoubleTensor matrixMultiply(DoubleTensor that) {
        long[] thatShape = that.getShape();
        TensorShapeValidation.getMatrixMultiplicationResultingShape(this.shape, thatShape);
        double[] A = ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).asDoubleArray();
        double[] B = ((DoubleBuffer.PrimitiveDoubleWrapper)JVMDoubleTensor.getAsJVMTensor((NumberTensor)that).buffer).asDoubleArray();
        double[] C = new double[Ints.checkedCast((long)(this.shape[0] * thatShape[1]))];
        int N = Ints.checkedCast((long)thatShape[1]);
        int M = Ints.checkedCast((long)this.shape[0]);
        int K = Ints.checkedCast((long)this.shape[1]);
        openblas.cblas_dgemm((int)101, (int)111, (int)111, (int)M, (int)N, (int)K, (double)1.0, (double[])A, (int)K, (double[])B, (int)N, (double)0.0, (double[])C, (int)N);
        return new JVMDoubleTensor(C, new long[]{this.shape[0], thatShape[1]});
    }

    @Override
    public DoubleTensor tensorMultiply(DoubleTensor that, int[] dimsLeft, int[] dimsRight) {
        return TensorMulByMatrixMul.tensorMmul(this, that, dimsLeft, dimsRight);
    }

    @Override
    public int argMax() {
        return this.argCompare((value, min) -> value > min);
    }

    @Override
    public IntegerTensor argMax(int axis) {
        return this.argCompare((value, max) -> value > max, axis);
    }

    @Override
    public IntegerTensor nanArgMax(int axis) {
        return this.argCompare((value, max) -> Double.isNaN(max) || !Double.isNaN(value) && value > max, axis);
    }

    @Override
    public int nanArgMax() {
        return this.argCompare((value, max) -> Double.isNaN(max) || !Double.isNaN(value) && value > max);
    }

    @Override
    public IntegerTensor argMin(int axis) {
        return this.argCompare((value, min) -> value < min, axis);
    }

    @Override
    public int argMin() {
        return this.argCompare((value, min) -> value < min);
    }

    @Override
    public IntegerTensor nanArgMin(int axis) {
        return this.argCompare((value, min) -> Double.isNaN(min) || !Double.isNaN(value) && value < min, axis);
    }

    @Override
    public int nanArgMin() {
        return this.argCompare((value, min) -> Double.isNaN(min) || !Double.isNaN(value) && value < min);
    }

    @Override
    public DoubleTensor unaryMinusInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply((T v) -> -v.doubleValue());
        return this;
    }

    @Override
    public DoubleTensor absInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(Math::abs);
        return this;
    }

    @Override
    public DoubleTensor applyInPlace(Function<Double, Double> function) {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(function);
        return this;
    }

    @Override
    public DoubleTensor greaterThanMask(DoubleTensor greaterThanThis) {
        return this.duplicate().broadcastableBinaryOpWithAutoBroadcast(BroadcastableDoubleOperations.GT_MASK, JVMDoubleTensor.getAsJVMTensor(greaterThanThis));
    }

    @Override
    public DoubleTensor greaterThanOrEqualToMask(DoubleTensor greaterThanThis) {
        return this.duplicate().broadcastableBinaryOpWithAutoBroadcast(BroadcastableDoubleOperations.GTE_MASK, JVMDoubleTensor.getAsJVMTensor(greaterThanThis));
    }

    @Override
    public DoubleTensor lessThanMask(DoubleTensor lessThanThis) {
        return this.duplicate().broadcastableBinaryOpWithAutoBroadcast(BroadcastableDoubleOperations.LT_MASK, JVMDoubleTensor.getAsJVMTensor(lessThanThis));
    }

    @Override
    public DoubleTensor lessThanOrEqualToMask(DoubleTensor lessThanThis) {
        return this.duplicate().broadcastableBinaryOpWithAutoBroadcast(BroadcastableDoubleOperations.LTE_MASK, JVMDoubleTensor.getAsJVMTensor(lessThanThis));
    }

    @Override
    public DoubleTensor setWithMaskInPlace(DoubleTensor mask, Double value) {
        this.checkMaskLengthMatches(mask);
        DoubleBuffer.PrimitiveDoubleWrapper maskBuffer = (DoubleBuffer.PrimitiveDoubleWrapper)JVMDoubleTensor.getAsJVMTensor((NumberTensor)mask).buffer;
        int i = 0;
        while ((long)i < ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength()) {
            if ((Double)maskBuffer.get(i) == 1.0) {
                ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).set(value, i);
            }
            ++i;
        }
        return this;
    }

    private void checkMaskLengthMatches(DoubleTensor mask) {
        if (this.getLength() != mask.getLength()) {
            throw new IllegalArgumentException("The lengths of the tensor and mask must match, but got tensor length: " + this.getLength() + ", mask length: " + mask.getLength());
        }
    }

    @Override
    public DoubleTensor setWithMask(DoubleTensor mask, Double value) {
        TensorShapeValidation.checkShapesMatch(this.shape, mask.getShape());
        DoubleBuffer.PrimitiveDoubleWrapper newBuffer = factory.createNew(((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength());
        DoubleBuffer.PrimitiveDoubleWrapper maskBuffer = (DoubleBuffer.PrimitiveDoubleWrapper)JVMDoubleTensor.getAsJVMTensor((NumberTensor)mask).buffer;
        int i = 0;
        while ((long)i < ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength()) {
            newBuffer.set((Double)maskBuffer.get(i) == 1.0 ? value : (Double)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(i), i);
            ++i;
        }
        return new JVMDoubleTensor(newBuffer, this.shapeCopy());
    }

    @Override
    public BooleanTensor lessThan(DoubleTensor that) {
        return this.maskToBooleanTensor(this.lessThanMask(that));
    }

    @Override
    public BooleanTensor lessThanOrEqual(DoubleTensor that) {
        return this.maskToBooleanTensor(this.lessThanOrEqualToMask(that));
    }

    @Override
    public BooleanTensor greaterThan(DoubleTensor that) {
        return this.maskToBooleanTensor(this.greaterThanMask(that));
    }

    @Override
    public BooleanTensor greaterThanOrEqual(DoubleTensor that) {
        return this.maskToBooleanTensor(this.greaterThanOrEqualToMask(that));
    }

    private BooleanTensor maskToBooleanTensor(DoubleTensor mask) {
        DoubleBuffer.PrimitiveDoubleWrapper maskBuffer = (DoubleBuffer.PrimitiveDoubleWrapper)JVMDoubleTensor.getAsJVMTensor((NumberTensor)mask).buffer;
        boolean[] boolBuffer = new boolean[Ints.checkedCast((long)maskBuffer.getLength())];
        int i = 0;
        while ((long)i < maskBuffer.getLength()) {
            boolBuffer[i] = (Double)maskBuffer.get(i) == 1.0;
            ++i;
        }
        return BooleanTensor.create(boolBuffer, mask.getShape());
    }

    @Override
    public BooleanTensor lessThan(Double value) {
        boolean[] newBuffer = new boolean[Ints.checkedCast((long)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength())];
        int i = 0;
        while ((long)i < ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength()) {
            newBuffer[i] = (Double)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(i) < value;
            ++i;
        }
        return BooleanTensor.create(newBuffer, this.shapeCopy());
    }

    @Override
    public BooleanTensor lessThanOrEqual(Double value) {
        boolean[] newBuffer = new boolean[Ints.checkedCast((long)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength())];
        int i = 0;
        while ((long)i < ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength()) {
            newBuffer[i] = (Double)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(i) <= value;
            ++i;
        }
        return BooleanTensor.create(newBuffer, this.shapeCopy());
    }

    @Override
    public BooleanTensor greaterThan(Double value) {
        boolean[] newBuffer = new boolean[Ints.checkedCast((long)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength())];
        int i = 0;
        while ((long)i < ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength()) {
            newBuffer[i] = (Double)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(i) > value;
            ++i;
        }
        return BooleanTensor.create(newBuffer, this.shapeCopy());
    }

    @Override
    public BooleanTensor greaterThanOrEqual(Double value) {
        boolean[] newBuffer = new boolean[Ints.checkedCast((long)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength())];
        int i = 0;
        while ((long)i < ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength()) {
            newBuffer[i] = (Double)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(i) >= value;
            ++i;
        }
        return BooleanTensor.create(newBuffer, this.shapeCopy());
    }

    @Override
    public DoubleTensor powInPlace(DoubleTensor exponent) {
        if (exponent.isScalar()) {
            return this.powInPlace((Double)exponent.scalar());
        }
        return this.broadcastableBinaryOpWithAutoBroadcast(FastMath::pow, JVMDoubleTensor.getAsJVMTensor(exponent));
    }

    @Override
    public DoubleTensor powInPlace(Double exponent) {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).pow(exponent);
        return this;
    }

    @Override
    public DoubleTensor atan2InPlace(Double y) {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).applyLeft(FastMath::atan2, y);
        return this;
    }

    @Override
    public DoubleTensor atan2InPlace(DoubleTensor y) {
        return this.broadcastableBinaryOpWithAutoBroadcast((left, right) -> FastMath.atan2((double)right, (double)left), JVMDoubleTensor.getAsJVMTensor(y));
    }

    @Override
    public Double average() {
        return (Double)this.sum() / (double)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength();
    }

    @Override
    public Double standardDeviation() {
        SummaryStatistics stats = new SummaryStatistics();
        int i = 0;
        while ((long)i < ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength()) {
            stats.addValue(((Double)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(i)).doubleValue());
            ++i;
        }
        return stats.getStandardDeviation();
    }

    @Override
    public boolean equalsWithinEpsilon(DoubleTensor other, Double epsilon) {
        if (!Arrays.equals(this.shape, other.getShape())) {
            return false;
        }
        DoubleBuffer.PrimitiveDoubleWrapper otherBuffer = (DoubleBuffer.PrimitiveDoubleWrapper)JVMDoubleTensor.getAsJVMTensor((NumberTensor)other).buffer;
        int i = 0;
        while ((long)i < ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength()) {
            if (Math.abs((Double)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(i) - (Double)otherBuffer.get(i)) > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public DoubleTensor sigmoidInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(arg_0 -> ((Sigmoid)sigmoid).value(arg_0));
        return this;
    }

    @Override
    public DoubleTensor take(long ... index) {
        return JVMDoubleTensor.scalar((Double)this.getValue(index));
    }

    public static DoubleTensor concat(int dimension, DoubleTensor ... toConcat) {
        return new JVMDoubleTensor(JVMTensor.concat(factory, toConcat, dimension, Arrays.stream(toConcat).map(tensor -> (DoubleBuffer.PrimitiveDoubleWrapper)JVMDoubleTensor.getAsJVMTensor((NumberTensor)tensor).buffer).collect(Collectors.toList())));
    }

    @Override
    public double[] asFlatDoubleArray() {
        return ((DoubleBuffer.PrimitiveDoubleWrapper)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).copy()).asDoubleArray();
    }

    @Override
    public int[] asFlatIntegerArray() {
        return ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).asIntegerArray();
    }

    public Double[] asFlatArray() {
        return (Double[])((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).asArray();
    }

    @Override
    public DoubleTensor reciprocalInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).reverseDiv(1.0);
        return this;
    }

    @Override
    public DoubleTensor sqrtInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::sqrt);
        return this;
    }

    @Override
    public DoubleTensor logInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::log);
        return this;
    }

    @Override
    public DoubleTensor safeLogTimesInPlace(DoubleTensor y) {
        TensorValidator.NAN_CATCHER.validate(this);
        TensorValidator.NAN_CATCHER.validate(y);
        DoubleTensor result = this.logInPlace().timesInPlace(y);
        return TensorValidator.NAN_FIXER.validate(result);
    }

    @Override
    public DoubleTensor logGammaInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(Gamma::logGamma);
        return this;
    }

    @Override
    public DoubleTensor digammaInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(Gamma::digamma);
        return this;
    }

    @Override
    public DoubleTensor sinInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::sin);
        return this;
    }

    @Override
    public DoubleTensor cosInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::cos);
        return this;
    }

    @Override
    public DoubleTensor tanInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::tan);
        return this;
    }

    @Override
    public DoubleTensor atanInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::atan);
        return this;
    }

    @Override
    public DoubleTensor asinInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::asin);
        return this;
    }

    @Override
    public DoubleTensor acosInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::acos);
        return this;
    }

    @Override
    public DoubleTensor sinhInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::sinh);
        return this;
    }

    @Override
    public DoubleTensor coshInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::cosh);
        return this;
    }

    @Override
    public DoubleTensor tanhInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::tanh);
        return this;
    }

    @Override
    public DoubleTensor asinhInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::asinh);
        return this;
    }

    @Override
    public DoubleTensor acoshInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::acosh);
        return this;
    }

    @Override
    public DoubleTensor atanhInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::atanh);
        return this;
    }

    @Override
    public DoubleTensor expInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::exp);
        return this;
    }

    @Override
    public DoubleTensor logAddExp2InPlace(DoubleTensor that) {
        return this.broadcastableBinaryOpWithAutoBroadcast(BroadcastableDoubleOperations.LOG_ADD_EXP2, JVMDoubleTensor.getAsJVMTensor(that));
    }

    @Override
    public DoubleTensor logAddExpInPlace(DoubleTensor that) {
        return this.broadcastableBinaryOpWithAutoBroadcast(BroadcastableDoubleOperations.LOG_ADD_EXP, JVMDoubleTensor.getAsJVMTensor(that));
    }

    @Override
    public DoubleTensor log1pInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::log1p);
        return this;
    }

    @Override
    public DoubleTensor log2InPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply((T v) -> FastMath.log((double)v) / FastMath.log((double)2.0));
        return this;
    }

    @Override
    public DoubleTensor log10InPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::log10);
        return this;
    }

    @Override
    public DoubleTensor exp2InPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply((T v) -> FastMath.pow((double)2.0, (double)v));
        return this;
    }

    @Override
    public DoubleTensor expM1InPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::expm1);
        return this;
    }

    @Override
    public Double min() {
        double result = Double.MAX_VALUE;
        int i = 0;
        while ((long)i < ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength()) {
            result = Math.min(result, (Double)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(i));
            ++i;
        }
        return result;
    }

    @Override
    public DoubleTensor minInPlace(DoubleTensor that) {
        return this.broadcastableBinaryOpWithAutoBroadcast(Math::min, JVMDoubleTensor.getAsJVMTensor(that));
    }

    @Override
    public Double max() {
        double result = -1.7976931348623157E308;
        int i = 0;
        while ((long)i < ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength()) {
            result = Math.max(result, (Double)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(i));
            ++i;
        }
        return result;
    }

    @Override
    public DoubleTensor maxInPlace(DoubleTensor that) {
        return this.broadcastableBinaryOpWithAutoBroadcast(Math::max, JVMDoubleTensor.getAsJVMTensor(that));
    }

    @Override
    public DoubleTensor clampInPlace(DoubleTensor min, DoubleTensor max) {
        this.maxInPlace(min);
        this.minInPlace(max);
        return this;
    }

    @Override
    public DoubleTensor ceilInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::ceil);
        return this;
    }

    @Override
    public DoubleTensor floorInPlace() {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).apply(FastMath::floor);
        return this;
    }

    @Override
    public DoubleTensor roundInPlace() {
        int i = 0;
        while ((long)i < ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength()) {
            if ((Double)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(i) >= 0.0) {
                ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).set(FastMath.floor((double)((Double)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(i) + 0.5)), i);
            } else {
                ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).set(FastMath.ceil((double)((Double)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(i) - 0.5)), i);
            }
            ++i;
        }
        return this;
    }

    @Override
    public DoubleTensor standardizeInPlace() {
        return (DoubleTensor)((Object)this.minusInPlace(this.average()).divInPlace(this.standardDeviation()));
    }

    @Override
    public DoubleTensor replaceNaNInPlace(Double value) {
        int i = 0;
        while ((long)i < ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength()) {
            ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).set(Double.isNaN((Double)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(i)) ? value : (Double)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(i), i);
            ++i;
        }
        return this;
    }

    @Override
    public DoubleTensor setAllInPlace(Double value) {
        int i = 0;
        while ((long)i < ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength()) {
            ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).set(value, i);
            ++i;
        }
        return this;
    }

    @Override
    public BooleanTensor notNaN() {
        return this.isApply(v -> !Double.isNaN(v));
    }

    @Override
    public BooleanTensor isNaN() {
        return this.isApply(v -> Double.isNaN(v));
    }

    @Override
    public BooleanTensor isFinite() {
        return this.isApply(Double::isFinite);
    }

    @Override
    public BooleanTensor isInfinite() {
        return this.isApply(v -> Double.isInfinite(v));
    }

    @Override
    public BooleanTensor isNegativeInfinity() {
        return this.isApply(v -> v == Double.NEGATIVE_INFINITY);
    }

    @Override
    public BooleanTensor isPositiveInfinity() {
        return this.isApply(v -> v == Double.POSITIVE_INFINITY);
    }

    @Override
    public DoubleTensor minusInPlace(Double value) {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).minus(value);
        return this;
    }

    @Override
    public DoubleTensor minusInPlace(DoubleTensor that) {
        if (this.isScalar()) {
            return (DoubleTensor)that.reverseMinus((Number)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(0L));
        }
        if (that.isScalar()) {
            return this.minusInPlace((Double)that.scalar());
        }
        return this.broadcastableBinaryOpWithAutoBroadcast(BroadcastableDoubleOperations.SUB, JVMDoubleTensor.getAsJVMTensor(that));
    }

    @Override
    public DoubleTensor reverseMinusInPlace(DoubleTensor that) {
        if (this.isScalar()) {
            return (DoubleTensor)((Object)that.minus((Number)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(0L)));
        }
        if (that.isScalar()) {
            return this.reverseMinusInPlace((Double)that.scalar());
        }
        return this.broadcastableBinaryOpWithAutoBroadcast(BroadcastableDoubleOperations.RSUB, JVMDoubleTensor.getAsJVMTensor(that));
    }

    @Override
    public DoubleTensor reverseMinusInPlace(Double value) {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).reverseMinus(value);
        return this;
    }

    @Override
    public DoubleTensor plusInPlace(Double value) {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).plus(value);
        return this;
    }

    @Override
    public DoubleTensor plusInPlace(DoubleTensor that) {
        if (this.isScalar()) {
            return (DoubleTensor)((Object)that.plus((Number)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(0L)));
        }
        if (that.isScalar()) {
            return this.plusInPlace((Double)that.scalar());
        }
        return this.broadcastableBinaryOpWithAutoBroadcast(BroadcastableDoubleOperations.ADD, JVMDoubleTensor.getAsJVMTensor(that));
    }

    @Override
    public DoubleTensor timesInPlace(Double value) {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).times(value);
        return this;
    }

    @Override
    public DoubleTensor timesInPlace(DoubleTensor that) {
        if (this.isScalar()) {
            return (DoubleTensor)((Object)that.times((Number)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(0L)));
        }
        if (that.isScalar()) {
            return this.timesInPlace((Double)that.scalar());
        }
        return this.broadcastableBinaryOpWithAutoBroadcast(BroadcastableDoubleOperations.MUL, JVMDoubleTensor.getAsJVMTensor(that));
    }

    @Override
    public DoubleTensor divInPlace(Double that) {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).div(that);
        return this;
    }

    @Override
    public DoubleTensor divInPlace(DoubleTensor that) {
        if (this.isScalar()) {
            return (DoubleTensor)((Object)that.reverseDiv((Number)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(0L)));
        }
        if (that.isScalar()) {
            return this.divInPlace((Double)that.scalar());
        }
        return this.broadcastableBinaryOpWithAutoBroadcast(BroadcastableDoubleOperations.DIV, JVMDoubleTensor.getAsJVMTensor(that));
    }

    @Override
    public DoubleTensor reverseDivInPlace(Double value) {
        ((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).reverseDiv(value);
        return this;
    }

    @Override
    public DoubleTensor reverseDivInPlace(DoubleTensor that) {
        if (this.isScalar()) {
            return (DoubleTensor)((Object)that.div((Number)((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).get(0L)));
        }
        if (that.isScalar()) {
            return this.reverseDivInPlace((Double)that.scalar());
        }
        return this.broadcastableBinaryOpWithAutoBroadcast(BroadcastableDoubleOperations.RDIV, JVMDoubleTensor.getAsJVMTensor(that));
    }

    @Override
    public Tensor.FlattenedView<Double> getFlattenedView() {
        if (((DoubleBuffer.PrimitiveDoubleWrapper)this.buffer).getLength() == 1L) {
            return new ScalarJVMFlattenedView();
        }
        return new TensorJVMDoubleFlattenedView();
    }

    private static JVMDoubleTensor getAsJVMTensor(NumberTensor tensor) {
        if (tensor instanceof JVMDoubleTensor) {
            return (JVMDoubleTensor)tensor;
        }
        return new JVMDoubleTensor(factory.create(tensor.asFlatDoubleArray()), tensor.getShape(), tensor.getStride());
    }

    private class ScalarJVMFlattenedView
    extends JVMDoubleFlattenedView
    implements Tensor.FlattenedView<Double> {
        private ScalarJVMFlattenedView() {
        }

        @Override
        public Double getOrScalar(long index) {
            return (Double)((DoubleBuffer.PrimitiveDoubleWrapper)JVMDoubleTensor.this.buffer).get(0L);
        }
    }

    private class TensorJVMDoubleFlattenedView
    extends JVMDoubleFlattenedView
    implements Tensor.FlattenedView<Double> {
        private TensorJVMDoubleFlattenedView() {
        }

        @Override
        public Double getOrScalar(long index) {
            return this.get(index);
        }
    }

    private class JVMDoubleFlattenedView {
        private JVMDoubleFlattenedView() {
        }

        public long size() {
            return ((DoubleBuffer.PrimitiveDoubleWrapper)JVMDoubleTensor.this.buffer).getLength();
        }

        public Double get(long index) {
            return (Double)((DoubleBuffer.PrimitiveDoubleWrapper)JVMDoubleTensor.this.buffer).get(index);
        }

        public void set(long index, Double value) {
            ((DoubleBuffer.PrimitiveDoubleWrapper)JVMDoubleTensor.this.buffer).set(value, index);
        }
    }
}

