/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.dbl;

import io.improbable.keanu.tensor.FloatingPointTensor;
import io.improbable.keanu.tensor.TensorFactories;
import io.improbable.keanu.tensor.TensorShape;
import org.apache.commons.lang3.ArrayUtils;

public interface DoubleTensor
extends FloatingPointTensor<Double, DoubleTensor> {
    public static DoubleTensor create(double value, long[] shape) {
        return TensorFactories.doubleTensorFactory.create(value, shape);
    }

    public static DoubleTensor create(double[] values, long ... shape) {
        return TensorFactories.doubleTensorFactory.create(values, shape);
    }

    public static DoubleTensor create(double ... values) {
        return DoubleTensor.create(values, new long[]{values.length});
    }

    public static DoubleTensor ones(long ... shape) {
        return TensorFactories.doubleTensorFactory.ones(shape);
    }

    public static DoubleTensor eye(long n) {
        return TensorFactories.doubleTensorFactory.eye(n);
    }

    public static DoubleTensor zeros(long ... shape) {
        return TensorFactories.doubleTensorFactory.zeros(shape);
    }

    public static DoubleTensor linspace(double start, double end, int numberOfPoints) {
        return TensorFactories.doubleTensorFactory.linspace(start, end, numberOfPoints);
    }

    public static DoubleTensor arange(double start, double end) {
        return TensorFactories.doubleTensorFactory.arange(start, end);
    }

    public static DoubleTensor arange(double end) {
        return TensorFactories.doubleTensorFactory.arange(0.0, end);
    }

    public static DoubleTensor arange(double start, double end, double stepSize) {
        return TensorFactories.doubleTensorFactory.arange(start, end, stepSize);
    }

    public static DoubleTensor scalar(double scalarValue) {
        return TensorFactories.doubleTensorFactory.scalar(scalarValue);
    }

    public static DoubleTensor vector(double ... values) {
        return DoubleTensor.create(values, new long[]{values.length});
    }

    public static DoubleTensor stack(int dimension, DoubleTensor ... toStack) {
        long[] shape = toStack[0].getShape();
        int stackedRank = toStack[0].getRank() + 1;
        int absoluteDimension = TensorShape.getAbsoluteDimension(dimension, stackedRank);
        long[] stackedShape = ArrayUtils.insert((int)absoluteDimension, (long[])shape, (long[])new long[]{1L});
        DoubleTensor[] reshaped = new DoubleTensor[toStack.length];
        for (int i = 0; i < toStack.length; ++i) {
            reshaped[i] = (DoubleTensor)toStack[i].reshape(stackedShape);
        }
        return DoubleTensor.concat(absoluteDimension, reshaped);
    }

    public static DoubleTensor concat(DoubleTensor ... toConcat) {
        return DoubleTensor.concat(0, toConcat);
    }

    public static DoubleTensor concat(int dimension, DoubleTensor ... toConcat) {
        return TensorFactories.doubleTensorFactory.concat(dimension, toConcat);
    }

    public static DoubleTensor min(DoubleTensor a, DoubleTensor b) {
        return ((DoubleTensor)a.duplicate()).minInPlace(b);
    }

    public static DoubleTensor max(DoubleTensor a, DoubleTensor b) {
        return ((DoubleTensor)a.duplicate()).maxInPlace(b);
    }

    @Override
    default public DoubleTensor plus(double value) {
        return (DoubleTensor)((Object)this.plus(Double.valueOf(value)));
    }

    @Override
    default public DoubleTensor minus(double value) {
        return (DoubleTensor)((Object)this.minus(Double.valueOf(value)));
    }

    @Override
    default public DoubleTensor reverseMinus(double value) {
        return (DoubleTensor)this.reverseMinus(Double.valueOf(value));
    }

    @Override
    default public DoubleTensor times(double value) {
        return (DoubleTensor)((Object)this.times(Double.valueOf(value)));
    }

    @Override
    default public DoubleTensor div(double value) {
        return (DoubleTensor)((Object)this.div(Double.valueOf(value)));
    }

    @Override
    default public DoubleTensor reverseDiv(double value) {
        return (DoubleTensor)((Object)this.reverseDiv(Double.valueOf(value)));
    }

    @Override
    default public DoubleTensor pow(double exponent) {
        return (DoubleTensor)this.pow(Double.valueOf(exponent));
    }
}

