/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.dbl;

import com.google.common.primitives.Ints;
import io.improbable.keanu.tensor.buffer.JVMBuffer;
import io.improbable.keanu.tensor.buffer.PrimitiveNumberWrapper;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.util.FastMath;

public class DoubleBuffer {

    public static final class DoubleWrapper
    extends JVMBuffer.SingleValueWrapper<Double, PrimitiveDoubleWrapper>
    implements PrimitiveDoubleWrapper {
        public DoubleWrapper(double value) {
            super(value);
        }

        @Override
        public Double sum() {
            return (Double)this.value;
        }

        @Override
        public Double product() {
            return (Double)this.value;
        }

        @Override
        public PrimitiveDoubleWrapper times(Double that) {
            this.value = (Double)this.value * that;
            return this;
        }

        @Override
        public PrimitiveDoubleWrapper div(Double that) {
            this.value = (Double)this.value / that;
            return this;
        }

        @Override
        public PrimitiveDoubleWrapper plus(Double that) {
            this.value = (Double)this.value + that;
            return this;
        }

        @Override
        public PrimitiveDoubleWrapper plus(long index, Double that) {
            this.value = (Double)this.value + that;
            return this;
        }

        @Override
        public PrimitiveDoubleWrapper minus(Double that) {
            this.value = (Double)this.value - that;
            return this;
        }

        @Override
        public PrimitiveDoubleWrapper pow(Double that) {
            this.value = FastMath.pow((double)((Double)this.value), (double)that);
            return this;
        }

        @Override
        public PrimitiveDoubleWrapper reverseDiv(Double that) {
            this.value = that / (Double)this.value;
            return this;
        }

        @Override
        public PrimitiveDoubleWrapper reverseMinus(Double that) {
            this.value = that - (Double)this.value;
            return this;
        }

        @Override
        public PrimitiveDoubleWrapper times(long index, Double that) {
            this.value = (Double)this.value * that;
            return this;
        }

        @Override
        public int[] asIntegerArray() {
            return new int[]{((Double)this.value).intValue()};
        }

        @Override
        public double[] asDoubleArray() {
            return new double[]{(Double)this.value};
        }

        public Double[] asArray() {
            return new Double[]{(Double)this.value};
        }

        @Override
        public PrimitiveDoubleWrapper copy() {
            return new DoubleWrapper((Double)this.value);
        }

        @Override
        protected PrimitiveDoubleWrapper getThis() {
            return this;
        }
    }

    public static final class DoubleArrayWrapper
    implements PrimitiveDoubleWrapper {
        private final double[] array;

        public DoubleArrayWrapper(double[] array) {
            this.array = array;
        }

        @Override
        public Double get(long index) {
            return this.array[Ints.checkedCast((long)index)];
        }

        @Override
        public DoubleArrayWrapper set(Double value, long index) {
            this.array[Ints.checkedCast((long)index)] = value;
            return this;
        }

        @Override
        public long getLength() {
            return this.array.length;
        }

        @Override
        public PrimitiveDoubleWrapper copy() {
            return new DoubleArrayWrapper(Arrays.copyOf(this.array, this.array.length));
        }

        @Override
        public DoubleArrayWrapper copyFrom(JVMBuffer.PrimitiveArrayWrapper<Double, ?> src, long srcPos, long destPos, long length) {
            if (src instanceof DoubleArrayWrapper) {
                System.arraycopy(((DoubleArrayWrapper)src).array, Ints.checkedCast((long)srcPos), this.array, Ints.checkedCast((long)destPos), Ints.checkedCast((long)length));
            } else {
                int i = 0;
                while ((long)i < length) {
                    this.array[Ints.checkedCast((long)(destPos + (long)i))] = src.get(srcPos + (long)i);
                    ++i;
                }
            }
            return this;
        }

        @Override
        public Double sum() {
            double result = 0.0;
            for (int i = 0; i < this.array.length; ++i) {
                result += this.array[i];
            }
            return result;
        }

        @Override
        public Double product() {
            double result = 1.0;
            for (int i = 0; i < this.array.length; ++i) {
                result *= this.array[i];
            }
            return result;
        }

        @Override
        public DoubleArrayWrapper times(Double that) {
            int i = 0;
            while (i < this.array.length) {
                int n = i++;
                this.array[n] = this.array[n] * that;
            }
            return this;
        }

        @Override
        public DoubleArrayWrapper div(Double that) {
            int i = 0;
            while (i < this.array.length) {
                int n = i++;
                this.array[n] = this.array[n] / that;
            }
            return this;
        }

        @Override
        public DoubleArrayWrapper plus(Double that) {
            int i = 0;
            while (i < this.array.length) {
                int n = i++;
                this.array[n] = this.array[n] + that;
            }
            return this;
        }

        @Override
        public DoubleArrayWrapper plus(long index, Double that) {
            int n = Ints.checkedCast((long)index);
            this.array[n] = this.array[n] + that;
            return this;
        }

        @Override
        public DoubleArrayWrapper times(long index, Double that) {
            int n = Ints.checkedCast((long)index);
            this.array[n] = this.array[n] * that;
            return this;
        }

        @Override
        public DoubleArrayWrapper minus(Double that) {
            int i = 0;
            while (i < this.array.length) {
                int n = i++;
                this.array[n] = this.array[n] - that;
            }
            return this;
        }

        @Override
        public DoubleArrayWrapper pow(Double that) {
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = FastMath.pow((double)this.array[i], (double)that);
            }
            return this;
        }

        @Override
        public DoubleArrayWrapper reverseDiv(Double that) {
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = that / this.array[i];
            }
            return this;
        }

        @Override
        public DoubleArrayWrapper reverseMinus(Double that) {
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = that - this.array[i];
            }
            return this;
        }

        @Override
        public DoubleArrayWrapper applyRight(BiFunction<Double, Double, Double> mapper, Double rightArg) {
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = mapper.apply(this.array[i], rightArg);
            }
            return this;
        }

        @Override
        public DoubleArrayWrapper applyLeft(BiFunction<Double, Double, Double> mapper, Double leftArg) {
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = mapper.apply(leftArg, this.array[i]);
            }
            return this;
        }

        @Override
        public DoubleArrayWrapper apply(Function<Double, Double> mapper) {
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = mapper.apply(this.array[i]);
            }
            return this;
        }

        @Override
        public int[] asIntegerArray() {
            int[] intBuffer = new int[this.array.length];
            for (int i = 0; i < this.array.length; ++i) {
                intBuffer[i] = (int)this.array[i];
            }
            return intBuffer;
        }

        @Override
        public double[] asDoubleArray() {
            return this.array;
        }

        public Double[] asArray() {
            return ArrayUtils.toObject((double[])this.array);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrimitiveDoubleWrapper)) {
                return false;
            }
            PrimitiveDoubleWrapper other = (PrimitiveDoubleWrapper)o;
            return Arrays.equals(this.array, other.asDoubleArray());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.array);
            return result;
        }
    }

    public static interface PrimitiveDoubleWrapper
    extends PrimitiveNumberWrapper<Double, PrimitiveDoubleWrapper> {
    }

    public static final class DoubleArrayWrapperFactory
    implements JVMBuffer.PrimitiveNumberWrapperFactory<Double, PrimitiveDoubleWrapper> {
        @Override
        public final PrimitiveDoubleWrapper createNew(long size) {
            if (size == 1L) {
                return new DoubleWrapper(0.0);
            }
            return new DoubleArrayWrapper(new double[Ints.checkedCast((long)size)]);
        }

        @Override
        public PrimitiveDoubleWrapper createNew(Double value) {
            return new DoubleWrapper(value);
        }

        @Override
        public PrimitiveDoubleWrapper zeroes(long size) {
            return this.createNew(size);
        }

        @Override
        public PrimitiveDoubleWrapper ones(long size) {
            if (size == 1L) {
                return new DoubleWrapper(1.0);
            }
            double[] ones = new double[Ints.checkedCast((long)size)];
            Arrays.fill(ones, 1.0);
            return new DoubleArrayWrapper(ones);
        }

        public final PrimitiveDoubleWrapper create(double[] data) {
            if (data.length == 1) {
                return new DoubleWrapper(data[0]);
            }
            return new DoubleArrayWrapper(data);
        }
    }
}

