/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.dbl;

import java.util.function.BiFunction;
import org.apache.commons.math3.util.FastMath;

public enum BroadcastableDoubleOperations implements BiFunction<Double, Double, Double>
{
    ADD{

        @Override
        public Double apply(Double left, Double right) {
            return left + right;
        }
    }
    ,
    SUB{

        @Override
        public Double apply(Double left, Double right) {
            return left - right;
        }
    }
    ,
    RSUB{

        @Override
        public Double apply(Double left, Double right) {
            return right - left;
        }
    }
    ,
    MUL{

        @Override
        public Double apply(Double left, Double right) {
            return left * right;
        }
    }
    ,
    DIV{

        @Override
        public Double apply(Double left, Double right) {
            return left / right;
        }
    }
    ,
    RDIV{

        @Override
        public Double apply(Double left, Double right) {
            return right / left;
        }
    }
    ,
    LOG_ADD_EXP{

        @Override
        public Double apply(Double a, Double b) {
            double max = Math.max(a, b);
            return max + FastMath.log((double)(FastMath.exp((double)(a - max)) + FastMath.exp((double)(b - max))));
        }
    }
    ,
    LOG_ADD_EXP2{
        private final double LOG2 = FastMath.log((double)2.0);

        @Override
        public Double apply(Double a, Double b) {
            double max = Math.max(a, b);
            return max + FastMath.log((double)(FastMath.pow((double)2.0, (double)(a - max)) + FastMath.pow((double)2.0, (double)(b - max)))) / this.LOG2;
        }
    }
    ,
    GT_MASK{

        @Override
        public Double apply(Double left, Double right) {
            return left > right ? 1.0 : 0.0;
        }
    }
    ,
    GTE_MASK{

        @Override
        public Double apply(Double left, Double right) {
            return left >= right ? 1.0 : 0.0;
        }
    }
    ,
    LT_MASK{

        @Override
        public Double apply(Double left, Double right) {
            return left < right ? 1.0 : 0.0;
        }
    }
    ,
    LTE_MASK{

        @Override
        public Double apply(Double left, Double right) {
            return left <= right ? 1.0 : 0.0;
        }
    };

}

