/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.buffer;

import com.google.common.primitives.Ints;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public class JVMBuffer {

    public static interface PrimitiveNumberWrapperFactory<D, T extends PrimitiveArrayWrapper<D, T>>
    extends ArrayWrapperFactory<D, T> {
        public T zeroes(long var1);

        public T ones(long var1);
    }

    public static interface ArrayWrapperFactory<D, T extends PrimitiveArrayWrapper<D, T>> {
        public T createNew(long var1);

        public T createNew(D var1);
    }

    public static abstract class SingleValueWrapper<T, IMPL extends PrimitiveArrayWrapper<T, IMPL>>
    implements PrimitiveArrayWrapper<T, IMPL> {
        protected T value;

        public SingleValueWrapper(T value) {
            this.value = value;
        }

        @Override
        public T get(long index) {
            return this.value;
        }

        @Override
        public IMPL set(T value, long index) {
            this.value = value;
            return this.getThis();
        }

        @Override
        public long getLength() {
            return 1L;
        }

        @Override
        public IMPL copyFrom(PrimitiveArrayWrapper<T, ?> src, long srcPos, long destPos, long length) {
            if (length == 1L && destPos == 0L) {
                this.value = src.get(srcPos);
            } else if (length > 1L || length < 0L || destPos != 0L) {
                throw new IndexOutOfBoundsException();
            }
            return this.getThis();
        }

        @Override
        public IMPL apply(Function<T, T> mapper) {
            this.value = mapper.apply(this.value);
            return this.getThis();
        }

        @Override
        public IMPL applyRight(BiFunction<T, T, T> mapper, T rightArg) {
            this.value = mapper.apply(this.value, rightArg);
            return this.getThis();
        }

        @Override
        public IMPL applyLeft(BiFunction<T, T, T> mapper, T leftArg) {
            this.value = mapper.apply(leftArg, this.value);
            return this.getThis();
        }

        protected abstract IMPL getThis();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleValueWrapper that = (SingleValueWrapper)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public static interface PrimitiveArrayWrapper<T, IMPL extends PrimitiveArrayWrapper<T, IMPL>> {
        public T[] asArray();

        default public T[] asArray(long from, long to) {
            Object[] temp = new Object[Ints.checkedCast((long)(to - from))];
            for (long i = from; i < to; ++i) {
                temp[(int)(i - from)] = this.get(i);
            }
            return temp;
        }

        public T get(long var1);

        public IMPL set(T var1, long var2);

        public long getLength();

        public IMPL copy();

        public IMPL copyFrom(PrimitiveArrayWrapper<T, ?> var1, long var2, long var4, long var6);

        public IMPL apply(Function<T, T> var1);

        public IMPL applyRight(BiFunction<T, T, T> var1, T var2);

        public IMPL applyLeft(BiFunction<T, T, T> var1, T var2);
    }
}

