/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.bool;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.TensorShape;
import io.improbable.keanu.tensor.bool.BooleanBuffer;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.tensor.bool.BroadcastableBooleanOperations;
import io.improbable.keanu.tensor.buffer.JVMBuffer;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import io.improbable.keanu.tensor.jvm.JVMTensor;
import io.improbable.keanu.tensor.jvm.ResultWrapper;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public class JVMBooleanTensor
extends JVMTensor<Boolean, BooleanTensor, BooleanBuffer.PrimitiveBooleanWrapper>
implements BooleanTensor {
    private static final BooleanBuffer.BooleanArrayWrapperFactory factory = new BooleanBuffer.BooleanArrayWrapperFactory();

    private JVMBooleanTensor(BooleanBuffer.PrimitiveBooleanWrapper buffer, long[] shape, long[] stride) {
        super(buffer, shape, stride);
    }

    private JVMBooleanTensor(BooleanBuffer.PrimitiveBooleanWrapper buffer, long[] shape) {
        super(buffer, shape, TensorShape.getRowFirstStride(shape));
    }

    private JVMBooleanTensor(boolean[] buffer, long[] shape) {
        this(factory.create(buffer), shape);
    }

    private JVMBooleanTensor(boolean[] buffer, long[] shape, long[] stride) {
        this(factory.create(buffer), shape, stride);
    }

    private JVMBooleanTensor(boolean constant) {
        super(new BooleanBuffer.BooleanWrapper(constant), new long[0], new long[0]);
    }

    private JVMBooleanTensor(ResultWrapper<Boolean, BooleanBuffer.PrimitiveBooleanWrapper> wrapper) {
        this((BooleanBuffer.PrimitiveBooleanWrapper)wrapper.outputBuffer, wrapper.outputShape, wrapper.outputStride);
    }

    @Override
    protected BooleanTensor create(BooleanBuffer.PrimitiveBooleanWrapper buffer, long[] shape, long[] stride) {
        return new JVMBooleanTensor(buffer, shape, stride);
    }

    @Override
    protected BooleanTensor set(BooleanBuffer.PrimitiveBooleanWrapper buffer, long[] shape, long[] stride) {
        this.buffer = buffer;
        this.shape = shape;
        this.stride = stride;
        return this;
    }

    @Override
    protected JVMBuffer.ArrayWrapperFactory<Boolean, BooleanBuffer.PrimitiveBooleanWrapper> getFactory() {
        return factory;
    }

    public static JVMBooleanTensor scalar(boolean scalarValue) {
        return new JVMBooleanTensor(scalarValue);
    }

    public static JVMBooleanTensor create(boolean[] values, long ... shape) {
        Preconditions.checkArgument((TensorShape.getLength(shape) == (long)values.length ? 1 : 0) != 0, (Object)("Shape " + Arrays.toString(shape) + " does not match data length " + values.length));
        return new JVMBooleanTensor(values, shape);
    }

    public static JVMBooleanTensor create(boolean value, long ... shape) {
        boolean[] buffer = new boolean[TensorShape.getLengthAsInt(shape)];
        if (value) {
            Arrays.fill(buffer, value);
        }
        return new JVMBooleanTensor(buffer, shape);
    }

    public static BooleanTensor concat(int dimension, BooleanTensor ... toConcat) {
        return new JVMBooleanTensor(JVMTensor.concat(factory, toConcat, dimension, Arrays.stream(toConcat).map(tensor -> (BooleanBuffer.PrimitiveBooleanWrapper)JVMBooleanTensor.getAsJVMTensor((BooleanTensor)tensor).buffer).collect(Collectors.toList())));
    }

    private static JVMBooleanTensor getAsJVMTensor(BooleanTensor tensor) {
        if (tensor instanceof JVMBooleanTensor) {
            return (JVMBooleanTensor)tensor;
        }
        return new JVMBooleanTensor(factory.create(tensor.asFlatBooleanArray()), tensor.getShape(), tensor.getStride());
    }

    @Override
    public DoubleTensor doubleWhere(DoubleTensor trueValue, DoubleTensor falseValue) {
        Tensor.FlattenedView trueValuesFlattened = trueValue.getFlattenedView();
        Tensor.FlattenedView falseValuesFlattened = falseValue.getFlattenedView();
        double[] result = new double[Ints.checkedCast((long)((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).getLength())];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Boolean)((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).get(i) != false ? ((Double)trueValuesFlattened.getOrScalar(i)).doubleValue() : ((Double)falseValuesFlattened.getOrScalar(i)).doubleValue();
        }
        return DoubleTensor.create(result, Arrays.copyOf(this.shape, this.shape.length));
    }

    @Override
    public IntegerTensor integerWhere(IntegerTensor trueValue, IntegerTensor falseValue) {
        Tensor.FlattenedView trueValuesFlattened = trueValue.getFlattenedView();
        Tensor.FlattenedView falseValuesFlattened = falseValue.getFlattenedView();
        int[] result = new int[Ints.checkedCast((long)((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).getLength())];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Boolean)((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).get(i) != false ? ((Integer)trueValuesFlattened.getOrScalar(i)).intValue() : ((Integer)falseValuesFlattened.getOrScalar(i)).intValue();
        }
        return IntegerTensor.create(result, Arrays.copyOf(this.shape, this.shape.length));
    }

    @Override
    public BooleanTensor booleanWhere(BooleanTensor trueValue, BooleanTensor falseValue) {
        Tensor.FlattenedView trueValuesFlattened = trueValue.getFlattenedView();
        Tensor.FlattenedView falseValuesFlattened = falseValue.getFlattenedView();
        boolean[] result = new boolean[Ints.checkedCast((long)((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).getLength())];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Boolean)((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).get(i) != false ? ((Boolean)trueValuesFlattened.getOrScalar(i)).booleanValue() : ((Boolean)falseValuesFlattened.getOrScalar(i)).booleanValue();
        }
        return BooleanTensor.create(result, Arrays.copyOf(this.shape, this.shape.length));
    }

    @Override
    public <T, TENSOR extends Tensor<T, TENSOR>> TENSOR where(TENSOR trueValue, TENSOR falseValue) {
        if (trueValue instanceof DoubleTensor && falseValue instanceof DoubleTensor) {
            return (TENSOR)this.doubleWhere((DoubleTensor)trueValue, (DoubleTensor)falseValue);
        }
        if (trueValue instanceof IntegerTensor && falseValue instanceof IntegerTensor) {
            return (TENSOR)this.integerWhere((IntegerTensor)trueValue, (IntegerTensor)falseValue);
        }
        if (trueValue instanceof BooleanTensor && falseValue instanceof BooleanTensor) {
            return (TENSOR)this.booleanWhere((BooleanTensor)trueValue, (BooleanTensor)falseValue);
        }
        Tensor.FlattenedView<T> trueValuesFlattened = trueValue.getFlattenedView();
        Tensor.FlattenedView<T> falseValuesFlattened = falseValue.getFlattenedView();
        Object[] result = new Object[Ints.checkedCast((long)((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).getLength())];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Boolean)((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).get(i) != false ? trueValuesFlattened.getOrScalar(i) : falseValuesFlattened.getOrScalar(i);
        }
        return Tensor.create(result, Arrays.copyOf(this.shape, this.shape.length));
    }

    @Override
    public BooleanTensor andInPlace(BooleanTensor that) {
        return this.broadcastableBinaryOpWithAutoBroadcast(BroadcastableBooleanOperations.AND, JVMBooleanTensor.getAsJVMTensor(that));
    }

    @Override
    public BooleanTensor andInPlace(boolean that) {
        if (!that) {
            ((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).applyRight((l, r) -> r, false);
        }
        return this;
    }

    @Override
    public BooleanTensor orInPlace(BooleanTensor that) {
        return this.broadcastableBinaryOpWithAutoBroadcast(BroadcastableBooleanOperations.OR, JVMBooleanTensor.getAsJVMTensor(that));
    }

    @Override
    public BooleanTensor orInPlace(boolean that) {
        if (that) {
            ((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).applyRight((l, r) -> r, true);
        }
        return this;
    }

    @Override
    public BooleanTensor xorInPlace(BooleanTensor that) {
        return this.broadcastableBinaryOpWithAutoBroadcast(BroadcastableBooleanOperations.XOR, JVMBooleanTensor.getAsJVMTensor(that));
    }

    @Override
    public BooleanTensor notInPlace() {
        ((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).apply(v -> v == false);
        return this;
    }

    @Override
    public boolean allTrue() {
        int i = 0;
        while ((long)i < ((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).getLength()) {
            if (!((Boolean)((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).get(i)).booleanValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean allFalse() {
        int i = 0;
        while ((long)i < ((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).getLength()) {
            if (((Boolean)((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).get(i)).booleanValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean anyTrue() {
        return !this.allFalse();
    }

    @Override
    public boolean anyFalse() {
        return !this.allTrue();
    }

    @Override
    public DoubleTensor toDoubleMask() {
        double[] doubles = this.asFlatDoubleArray();
        return DoubleTensor.create(doubles, Arrays.copyOf(this.shape, this.shape.length));
    }

    @Override
    public IntegerTensor toIntegerMask() {
        int[] doubles = this.asFlatIntegerArray();
        return IntegerTensor.create(doubles, Arrays.copyOf(this.shape, this.shape.length));
    }

    @Override
    public BooleanTensor take(long ... index) {
        return new JVMBooleanTensor((Boolean)this.getValue(index));
    }

    @Override
    public BooleanTensor duplicate() {
        return new JVMBooleanTensor((BooleanBuffer.PrimitiveBooleanWrapper)((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).copy(), Arrays.copyOf(this.shape, this.shape.length), Arrays.copyOf(this.stride, this.stride.length));
    }

    @Override
    public BooleanTensor elementwiseEquals(Boolean value) {
        return Tensor.elementwiseEquals(this, BooleanTensor.create((boolean)value, this.getShape()));
    }

    @Override
    public Tensor.FlattenedView<Boolean> getFlattenedView() {
        return new JVMBooleanFlattenedView();
    }

    @Override
    public double[] asFlatDoubleArray() {
        return ((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).asDoubleArray();
    }

    @Override
    public int[] asFlatIntegerArray() {
        return ((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).asIntegerArray();
    }

    public Boolean[] asFlatArray() {
        return ArrayUtils.toObject((boolean[])this.asFlatBooleanArray());
    }

    @Override
    public boolean[] asFlatBooleanArray() {
        return ((BooleanBuffer.PrimitiveBooleanWrapper)((BooleanBuffer.PrimitiveBooleanWrapper)this.buffer).copy()).asBooleanArray();
    }

    private class JVMBooleanFlattenedView
    implements Tensor.FlattenedView<Boolean> {
        private JVMBooleanFlattenedView() {
        }

        @Override
        public long size() {
            return ((BooleanBuffer.PrimitiveBooleanWrapper)JVMBooleanTensor.this.buffer).getLength();
        }

        @Override
        public Boolean get(long index) {
            return (Boolean)((BooleanBuffer.PrimitiveBooleanWrapper)JVMBooleanTensor.this.buffer).get(index);
        }

        @Override
        public Boolean getOrScalar(long index) {
            if (((BooleanBuffer.PrimitiveBooleanWrapper)JVMBooleanTensor.this.buffer).getLength() == 1L) {
                return this.get(0L);
            }
            return this.get(index);
        }

        @Override
        public void set(long index, Boolean value) {
            ((BooleanBuffer.PrimitiveBooleanWrapper)JVMBooleanTensor.this.buffer).set(value, index);
        }
    }
}

