/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.bool;

import io.improbable.keanu.kotlin.BooleanOperators;
import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.TensorShape;
import io.improbable.keanu.tensor.bool.JVMBooleanTensor;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import org.apache.commons.lang3.ArrayUtils;

public interface BooleanTensor
extends Tensor<Boolean, BooleanTensor>,
BooleanOperators<BooleanTensor> {
    public static BooleanTensor create(boolean value, long[] shape) {
        return JVMBooleanTensor.create(value, shape);
    }

    public static BooleanTensor create(boolean[] values, long ... shape) {
        return JVMBooleanTensor.create(values, shape);
    }

    public static BooleanTensor create(boolean ... values) {
        return BooleanTensor.create(values, values.length);
    }

    public static BooleanTensor scalar(boolean scalarValue) {
        return JVMBooleanTensor.scalar(scalarValue);
    }

    public static BooleanTensor vector(boolean ... values) {
        return BooleanTensor.create(values, values.length);
    }

    public static BooleanTensor trues(long ... shape) {
        return JVMBooleanTensor.create(true, shape);
    }

    public static BooleanTensor falses(long ... shape) {
        return JVMBooleanTensor.create(false, shape);
    }

    public static BooleanTensor stack(int dimension, BooleanTensor ... toStack) {
        long[] shape = toStack[0].getShape();
        int stackedRank = toStack[0].getRank() + 1;
        int absoluteDimension = TensorShape.getAbsoluteDimension(dimension, stackedRank);
        long[] stackedShape = ArrayUtils.insert((int)absoluteDimension, (long[])shape, (long[])new long[]{1L});
        BooleanTensor[] reshaped = new BooleanTensor[toStack.length];
        for (int i = 0; i < toStack.length; ++i) {
            reshaped[i] = (BooleanTensor)toStack[i].reshape(stackedShape);
        }
        return BooleanTensor.concat(absoluteDimension, reshaped);
    }

    public static BooleanTensor concat(int dimension, BooleanTensor ... toConcat) {
        return JVMBooleanTensor.concat(dimension, toConcat);
    }

    @Override
    default public BooleanTensor and(BooleanTensor that) {
        return ((BooleanTensor)this.duplicate()).andInPlace(that);
    }

    public BooleanTensor andInPlace(BooleanTensor var1);

    @Override
    default public BooleanTensor and(boolean that) {
        return ((BooleanTensor)this.duplicate()).andInPlace(that);
    }

    public BooleanTensor andInPlace(boolean var1);

    @Override
    default public BooleanTensor or(BooleanTensor that) {
        return ((BooleanTensor)this.duplicate()).orInPlace(that);
    }

    public BooleanTensor orInPlace(BooleanTensor var1);

    @Override
    default public BooleanTensor or(boolean that) {
        return ((BooleanTensor)this.duplicate()).orInPlace(that);
    }

    public BooleanTensor orInPlace(boolean var1);

    default public BooleanTensor xor(BooleanTensor that) {
        return ((BooleanTensor)this.duplicate()).xorInPlace(that);
    }

    public BooleanTensor xorInPlace(BooleanTensor var1);

    @Override
    default public BooleanTensor not() {
        return ((BooleanTensor)this.duplicate()).notInPlace();
    }

    public BooleanTensor notInPlace();

    public DoubleTensor doubleWhere(DoubleTensor var1, DoubleTensor var2);

    public IntegerTensor integerWhere(IntegerTensor var1, IntegerTensor var2);

    public BooleanTensor booleanWhere(BooleanTensor var1, BooleanTensor var2);

    public <T, TENSOR extends Tensor<T, TENSOR>> TENSOR where(TENSOR var1, TENSOR var2);

    public boolean allTrue();

    public boolean allFalse();

    public boolean anyTrue();

    public boolean anyFalse();

    public DoubleTensor toDoubleMask();

    public IntegerTensor toIntegerMask();

    public double[] asFlatDoubleArray();

    public int[] asFlatIntegerArray();

    public boolean[] asFlatBooleanArray();
}

