/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor.bool;

import com.google.common.primitives.Ints;
import io.improbable.keanu.tensor.buffer.JVMBuffer;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;

public class BooleanBuffer {

    public static final class BooleanWrapper
    extends JVMBuffer.SingleValueWrapper<Boolean, PrimitiveBooleanWrapper>
    implements PrimitiveBooleanWrapper {
        public BooleanWrapper(boolean value) {
            super(value);
        }

        @Override
        public PrimitiveBooleanWrapper copy() {
            return new BooleanWrapper((Boolean)this.value);
        }

        @Override
        public int[] asIntegerArray() {
            return new int[]{(Boolean)this.value != false ? 1 : 0};
        }

        @Override
        public double[] asDoubleArray() {
            return new double[]{(Boolean)this.value != false ? 1.0 : 0.0};
        }

        @Override
        public boolean[] asBooleanArray() {
            return new boolean[]{(Boolean)this.value};
        }

        public Boolean[] asArray() {
            return new Boolean[]{(Boolean)this.value};
        }

        @Override
        protected PrimitiveBooleanWrapper getThis() {
            return this;
        }
    }

    public static final class BooleanArrayWrapper
    implements PrimitiveBooleanWrapper {
        private final boolean[] array;

        public BooleanArrayWrapper(boolean[] array) {
            this.array = array;
        }

        @Override
        public Boolean get(long index) {
            return this.array[Ints.checkedCast((long)index)];
        }

        @Override
        public BooleanArrayWrapper set(Boolean value, long index) {
            this.array[Ints.checkedCast((long)index)] = value;
            return this;
        }

        @Override
        public long getLength() {
            return this.array.length;
        }

        @Override
        public PrimitiveBooleanWrapper copy() {
            return new BooleanArrayWrapper(Arrays.copyOf(this.array, this.array.length));
        }

        @Override
        public BooleanArrayWrapper copyFrom(JVMBuffer.PrimitiveArrayWrapper<Boolean, ?> src, long srcPos, long destPos, long length) {
            if (src instanceof BooleanArrayWrapper) {
                System.arraycopy(((BooleanArrayWrapper)src).array, Ints.checkedCast((long)srcPos), this.array, Ints.checkedCast((long)destPos), Ints.checkedCast((long)length));
            } else {
                int i = 0;
                while ((long)i < length) {
                    this.array[Ints.checkedCast((long)(destPos + (long)i))] = src.get(srcPos + (long)i);
                    ++i;
                }
            }
            return this;
        }

        @Override
        public BooleanArrayWrapper applyRight(BiFunction<Boolean, Boolean, Boolean> mapper, Boolean rightArg) {
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = mapper.apply(this.array[i], rightArg);
            }
            return this;
        }

        @Override
        public BooleanArrayWrapper applyLeft(BiFunction<Boolean, Boolean, Boolean> mapper, Boolean leftArg) {
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = mapper.apply(leftArg, this.array[i]);
            }
            return this;
        }

        @Override
        public BooleanArrayWrapper apply(Function<Boolean, Boolean> mapper) {
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = mapper.apply(this.array[i]);
            }
            return this;
        }

        @Override
        public int[] asIntegerArray() {
            int[] intBuffer = new int[this.array.length];
            for (int i = 0; i < this.array.length; ++i) {
                intBuffer[i] = this.array[i] ? 1 : 0;
            }
            return intBuffer;
        }

        @Override
        public double[] asDoubleArray() {
            double[] intBuffer = new double[this.array.length];
            for (int i = 0; i < this.array.length; ++i) {
                intBuffer[i] = this.array[i] ? 1.0 : 0.0;
            }
            return intBuffer;
        }

        @Override
        public boolean[] asBooleanArray() {
            return this.array;
        }

        public Boolean[] asArray() {
            return ArrayUtils.toObject((boolean[])this.array);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrimitiveBooleanWrapper)) {
                return false;
            }
            PrimitiveBooleanWrapper other = (PrimitiveBooleanWrapper)o;
            return Arrays.equals(this.array, other.asBooleanArray());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.array);
            return result;
        }
    }

    public static interface PrimitiveBooleanWrapper
    extends JVMBuffer.PrimitiveArrayWrapper<Boolean, PrimitiveBooleanWrapper> {
        public int[] asIntegerArray();

        public double[] asDoubleArray();

        public boolean[] asBooleanArray();
    }

    public static final class BooleanArrayWrapperFactory
    implements JVMBuffer.ArrayWrapperFactory<Boolean, PrimitiveBooleanWrapper> {
        @Override
        public final PrimitiveBooleanWrapper createNew(long size) {
            if (size == 1L) {
                return new BooleanWrapper(false);
            }
            return new BooleanArrayWrapper(new boolean[Ints.checkedCast((long)size)]);
        }

        @Override
        public PrimitiveBooleanWrapper createNew(Boolean value) {
            return new BooleanWrapper(value);
        }

        public final PrimitiveBooleanWrapper create(boolean[] data) {
            if (data.length == 1) {
                return new BooleanWrapper(data[0]);
            }
            return new BooleanArrayWrapper(data);
        }
    }
}

