/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.tensor;

import io.improbable.keanu.kotlin.NumberOperators;
import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import java.util.function.Function;

public interface NumberTensor<N extends Number, T extends NumberTensor<N, T>>
extends Tensor<N, T>,
NumberOperators<T> {
    public DoubleTensor toDouble();

    public IntegerTensor toInteger();

    public double[] asFlatDoubleArray();

    public int[] asFlatIntegerArray();

    public N sum();

    public T sum(int ... var1);

    default public T cumSum(int requestedDimension) {
        return ((NumberTensor)this.duplicate()).cumSumInPlace(requestedDimension);
    }

    public T cumSumInPlace(int var1);

    public N product();

    public T product(int ... var1);

    default public T cumProd(int requestedDimension) {
        return ((NumberTensor)this.duplicate()).cumProdInPlace(requestedDimension);
    }

    public T cumProdInPlace(int var1);

    public N max();

    default public T max(T max) {
        return ((NumberTensor)this.duplicate()).maxInPlace(max);
    }

    public T maxInPlace(T var1);

    public N min();

    default public T min(T min) {
        return ((NumberTensor)this.duplicate()).minInPlace(min);
    }

    public T minInPlace(T var1);

    default public T clamp(T min, T max) {
        return ((NumberTensor)this.duplicate()).clampInPlace(min, max);
    }

    public T clampInPlace(T var1, T var2);

    public T matrixMultiply(T var1);

    public T tensorMultiply(T var1, int[] var2, int[] var3);

    default public T abs() {
        return ((NumberTensor)this.duplicate()).absInPlace();
    }

    public T absInPlace();

    @Override
    default public T minus(N value) {
        return (T)((NumberTensor)this.duplicate()).minusInPlace((T)value);
    }

    public T minusInPlace(N var1);

    @Override
    default public T minus(T that) {
        return ((NumberTensor)this.duplicate()).minusInPlace(that);
    }

    public T minusInPlace(T var1);

    default public T reverseMinus(T value) {
        return ((NumberTensor)this.duplicate()).reverseMinusInPlace((N)value);
    }

    public T reverseMinusInPlace(T var1);

    default public T reverseMinus(N value) {
        return ((NumberTensor)this.duplicate()).reverseMinusInPlace(value);
    }

    public T reverseMinusInPlace(N var1);

    @Override
    default public T plus(N value) {
        return (T)((NumberTensor)this.duplicate()).plusInPlace((T)value);
    }

    public T plusInPlace(N var1);

    @Override
    default public T plus(T that) {
        return ((NumberTensor)this.duplicate()).plusInPlace(that);
    }

    public T plusInPlace(T var1);

    @Override
    default public T unaryMinus() {
        return ((NumberTensor)this.duplicate()).unaryMinusInPlace();
    }

    public T unaryMinusInPlace();

    @Override
    default public T times(N value) {
        return (T)((NumberTensor)this.duplicate()).timesInPlace((T)value);
    }

    public T timesInPlace(N var1);

    @Override
    default public T times(T that) {
        return ((NumberTensor)this.duplicate()).timesInPlace(that);
    }

    public T timesInPlace(T var1);

    @Override
    default public T div(N value) {
        return (T)((NumberTensor)this.duplicate()).divInPlace((T)value);
    }

    public T divInPlace(N var1);

    @Override
    default public T div(T value) {
        return ((NumberTensor)this.duplicate()).divInPlace(value);
    }

    public T divInPlace(T var1);

    default public T reverseDiv(N value) {
        return (T)((NumberTensor)this.duplicate()).reverseDivInPlace((T)value);
    }

    public T reverseDivInPlace(N var1);

    default public T reverseDiv(T value) {
        return ((NumberTensor)this.duplicate()).reverseDivInPlace(value);
    }

    public T reverseDivInPlace(T var1);

    @Override
    default public T pow(T exponent) {
        return ((NumberTensor)this.duplicate()).powInPlace((N)exponent);
    }

    public T powInPlace(T var1);

    @Override
    default public T pow(N exponent) {
        return ((NumberTensor)this.duplicate()).powInPlace(exponent);
    }

    public T powInPlace(N var1);

    public N average();

    public N standardDeviation();

    public int argMax();

    public IntegerTensor argMax(int var1);

    public int argMin();

    public IntegerTensor argMin(int var1);

    default public T setWithMask(T mask, N value) {
        return ((NumberTensor)this.duplicate()).setWithMaskInPlace(mask, value);
    }

    public T setWithMaskInPlace(T var1, N var2);

    default public T apply(Function<N, N> function) {
        return ((NumberTensor)this.duplicate()).applyInPlace(function);
    }

    public T applyInPlace(Function<N, N> var1);

    public T setAllInPlace(N var1);

    default public T safeLogTimes(T y) {
        return ((NumberTensor)this.duplicate()).safeLogTimesInPlace(y);
    }

    public T safeLogTimesInPlace(T var1);

    public boolean equalsWithinEpsilon(T var1, N var2);

    public BooleanTensor lessThan(T var1);

    public BooleanTensor lessThanOrEqual(T var1);

    public BooleanTensor greaterThan(T var1);

    public BooleanTensor greaterThanOrEqual(T var1);

    public BooleanTensor lessThan(N var1);

    public BooleanTensor lessThanOrEqual(N var1);

    public BooleanTensor greaterThan(N var1);

    public BooleanTensor greaterThanOrEqual(N var1);

    public T greaterThanMask(T var1);

    public T greaterThanOrEqualToMask(T var1);

    public T lessThanMask(T var1);

    public T lessThanOrEqualToMask(T var1);
}

