/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.templating;

import io.improbable.keanu.algorithms.graphtraversal.TopologicalSort;
import io.improbable.keanu.network.BayesianNetwork;
import io.improbable.keanu.templating.Sequence;
import io.improbable.keanu.templating.SequenceBuilder;
import io.improbable.keanu.templating.SequenceConstructionException;
import io.improbable.keanu.templating.SequenceItem;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.VertexLabel;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SequenceLoader {
    public static Sequence loadFromBayesNet(BayesianNetwork network) {
        Collection<Sequence> sequences = SequenceLoader.loadSequences(network, false).values();
        return sequences.stream().findFirst().get();
    }

    public static Map<Integer, Sequence> loadMultipleSequencesFromBayesNet(BayesianNetwork network) {
        return SequenceLoader.loadSequences(network, true);
    }

    private static Map<Integer, Sequence> loadSequences(BayesianNetwork network, boolean shouldLoadMultiple) {
        List<Vertex> vertices = TopologicalSort.sort(network.getAllVertices());
        HashMap<Integer, Sequence> sequences = new HashMap<Integer, Sequence>();
        for (Vertex vertex : vertices) {
            SequenceLoader.addVertexToSequences(vertex, sequences);
            if (shouldLoadMultiple || sequences.size() <= 1) continue;
            throw new SequenceConstructionException("The provided BayesianNetwork contains more than one Sequence");
        }
        if (sequences.size() == 0) {
            throw new SequenceConstructionException("The provided BayesianNetwork contains no Sequences");
        }
        return sequences;
    }

    private static void addVertexToSequences(Vertex<?> vertex, Map<Integer, Sequence> sequences) {
        Optional<Integer> sequenceItemIndex;
        VertexLabel label = vertex.getLabel();
        if (label != null && (sequenceItemIndex = SequenceItem.parseSequenceItemIndex(label)).isPresent()) {
            Optional<String> sequenceName = SequenceItem.parseSequenceName(label);
            int sequenceHash = SequenceItem.parseSequenceHash(label, sequenceName.isPresent());
            Sequence sequence = SequenceLoader.getOrCreateSequence(sequences, sequenceHash, sequenceName.orElse(null));
            SequenceItem item = SequenceLoader.getOrCreateSequenceItem(sequence, sequenceItemIndex.get(), sequenceHash, sequenceName.orElse(null));
            VertexLabel newLabel = SequenceBuilder.getUnscopedLabel(label, sequenceName.isPresent());
            vertex.setLabel(newLabel);
            item.add(vertex);
        }
    }

    private static boolean sequenceContainsKey(Sequence sequence, int index) {
        List<SequenceItem> sequenceItems = sequence.asList();
        if (index >= sequenceItems.size()) {
            return false;
        }
        return sequenceItems.get(index) != null;
    }

    private static Sequence getOrCreateSequence(Map<Integer, Sequence> sequences, int sequenceHash, String sequenceName) {
        Sequence sequence;
        if (sequences.containsKey(sequenceHash)) {
            sequence = sequences.get(sequenceHash);
        } else {
            sequence = new Sequence(0, sequenceHash, sequenceName);
            sequences.put(sequenceHash, sequence);
        }
        return sequence;
    }

    private static SequenceItem getOrCreateSequenceItem(Sequence sequence, Integer sequenceItemIndex, int sequenceHash, String sequenceName) {
        SequenceItem sequenceItem;
        if (SequenceLoader.sequenceContainsKey(sequence, sequenceItemIndex)) {
            sequenceItem = sequence.asList().get(sequenceItemIndex);
        } else {
            sequenceItem = new SequenceItem(sequenceItemIndex, sequenceHash, sequenceName);
            sequence.add(sequenceItem);
        }
        return sequenceItem;
    }
}

