/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.templating;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.improbable.keanu.templating.SequenceBuilder;
import io.improbable.keanu.templating.SequenceConstructionException;
import io.improbable.keanu.vertices.ProxyVertex;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.VertexDictionary;
import io.improbable.keanu.vertices.VertexLabel;
import io.improbable.keanu.vertices.bool.nonprobabilistic.BooleanProxyVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.DoubleProxyVertex;
import io.improbable.keanu.vertices.intgr.nonprobabilistic.IntegerProxyVertex;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SequenceItem
implements VertexDictionary {
    private static final String NAME_PREFIX = "Sequence_Item_";
    private static Pattern NAME_REGEX = Pattern.compile("Sequence_Item_-?[\\d]+$");
    private Map<VertexLabel, Vertex<?>> contents = new HashMap();
    private int index;
    private int uniqueSequenceIdentifier;
    private String sequenceName;

    public SequenceItem(int index, int uniqueSequenceIdentifier) {
        this(index, uniqueSequenceIdentifier, null);
    }

    public SequenceItem(int index, int uniqueSequenceIdentifier, String sequenceName) {
        this.index = index;
        this.uniqueSequenceIdentifier = uniqueSequenceIdentifier;
        this.sequenceName = sequenceName;
    }

    public <T extends Vertex<?>> void addAll(T ... vertices) {
        this.addAll((Collection<T>)ImmutableList.copyOf((Object[])vertices));
    }

    public <T extends Vertex<?>> void addAll(Collection<T> vertices) {
        vertices.forEach(v -> this.add(v));
    }

    public <T extends Vertex<?>> void addAll(Map<VertexLabel, T> vertices) {
        vertices.entrySet().forEach(v -> this.add((VertexLabel)v.getKey(), (Vertex)v.getValue()));
    }

    public <T extends Vertex<?>> T add(T v) {
        return this.add(v.getLabel(), v);
    }

    public <T extends Vertex<?>> T add(VertexLabel label, T v) {
        if (label == null) {
            throw new SequenceConstructionException("Vertex " + v + " must contain a label in order to be added to a sequence item");
        }
        String outerNamespace = label.getOuterNamespace().orElse("");
        if (NAME_REGEX.matcher(outerNamespace).matches()) {
            throw new SequenceConstructionException("Vertex " + v + " has already been added to " + outerNamespace);
        }
        if (this.contents.containsKey(label = this.scoped(label))) {
            throw new IllegalArgumentException("Key " + label + " already exists");
        }
        this.contents.put(label, v);
        v.setLabel(label);
        return v;
    }

    public Map<VertexLabel, Vertex<?>> getContents() {
        return ImmutableMap.copyOf(this.contents);
    }

    public int getIndex() {
        return this.index;
    }

    private String getName() {
        return NAME_PREFIX + this.index;
    }

    private VertexLabel scoped(VertexLabel label) {
        VertexLabel scopedLabel = label.withExtraNamespace(String.valueOf(this.uniqueSequenceIdentifier)).withExtraNamespace(this.getName());
        if (this.sequenceName != null) {
            scopedLabel = scopedLabel.withExtraNamespace(this.sequenceName);
        }
        return scopedLabel;
    }

    @Override
    public <V extends Vertex<?>> V get(VertexLabel label) {
        Vertex<?> vertex = this.contents.getOrDefault(label, this.contents.get(this.scoped(label)));
        if (vertex == null) {
            throw new IllegalArgumentException("Cannot find VertexLabel " + label);
        }
        return (V)vertex;
    }

    @Override
    public SequenceItem withExtraEntries(Map<VertexLabel, Vertex<?>> extraEntries) {
        SequenceItem item = new SequenceItem(this.index, this.uniqueSequenceIdentifier, this.sequenceName);
        item.addAll(this.contents);
        item.addAll(extraEntries);
        return item;
    }

    public Collection<Vertex<?>> getProxyVertices() {
        return this.contents.values().stream().filter(v -> v instanceof ProxyVertex).collect(Collectors.toList());
    }

    public DoubleProxyVertex addDoubleProxyFor(VertexLabel label) {
        return this.addProxyFor(label, DoubleProxyVertex::new);
    }

    public DoubleProxyVertex addDoubleProxyFor(VertexLabel label, long[] shape) {
        return this.addProxyFor(label, shape, DoubleProxyVertex::new);
    }

    public IntegerProxyVertex addIntegerProxyFor(VertexLabel label) {
        return this.addProxyFor(label, IntegerProxyVertex::new);
    }

    public IntegerProxyVertex addIntegerProxyFor(VertexLabel label, long[] shape) {
        return this.addProxyFor(label, shape, IntegerProxyVertex::new);
    }

    public BooleanProxyVertex addBooleanProxyFor(VertexLabel label) {
        return this.addProxyFor(label, BooleanProxyVertex::new);
    }

    public BooleanProxyVertex addBooleanProxyFor(VertexLabel label, long[] shape) {
        return this.addProxyFor(label, shape, BooleanProxyVertex::new);
    }

    private <T extends Vertex<?>> T addProxyFor(VertexLabel label, Function<VertexLabel, T> factoryMethod) {
        return (T)this.addProxyFor(label, null, (shape, vertexLabel) -> (Vertex)factoryMethod.apply((VertexLabel)vertexLabel));
    }

    private <T extends Vertex<?>> T addProxyFor(VertexLabel label, long[] shape, BiFunction<long[], VertexLabel, T> factoryMethod) {
        VertexLabel proxyLabel = SequenceBuilder.proxyLabelFor(label);
        Vertex newVertex = (Vertex)factoryMethod.apply(shape, proxyLabel);
        this.add(newVertex);
        return (T)newVertex;
    }

    static Optional<Integer> parseSequenceItemIndex(VertexLabel label) {
        String outerNamespace = label.getOuterNamespace().orElse(null);
        if (outerNamespace == null) {
            return Optional.empty();
        }
        if (outerNamespace.startsWith(NAME_PREFIX)) {
            return Optional.of(Integer.parseInt(outerNamespace.replaceFirst(NAME_PREFIX, "")));
        }
        outerNamespace = label.withoutOuterNamespace().getOuterNamespace().orElse(null);
        if (outerNamespace == null) {
            return Optional.empty();
        }
        return Optional.of(Integer.parseInt(outerNamespace.replaceFirst(NAME_PREFIX, "")));
    }

    static Optional<String> parseSequenceName(VertexLabel label) {
        Optional<String> outerNamespace = label.getOuterNamespace();
        Optional<String> penultimateOuterNamespace = label.withoutOuterNamespace().getOuterNamespace();
        if (penultimateOuterNamespace.isPresent() && penultimateOuterNamespace.get().startsWith(NAME_PREFIX)) {
            return outerNamespace;
        }
        return Optional.empty();
    }

    static int parseSequenceHash(VertexLabel label, boolean sequenceHasName) {
        VertexLabel withHashAsOuterNamespace = label.withoutOuterNamespace();
        if (sequenceHasName) {
            withHashAsOuterNamespace = withHashAsOuterNamespace.withoutOuterNamespace();
        }
        String hashLabel = withHashAsOuterNamespace.getOuterNamespace().orElseThrow(() -> new SequenceConstructionException("Could not parse the sequence hash in the vertex label"));
        return Integer.parseInt(hashLabel);
    }
}

