/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.network.grouping.continuouspointgroupers;

import io.improbable.keanu.network.grouping.ContinuousPoint;
import io.improbable.keanu.network.grouping.continuouspointgroupers.ContinuousPointGrouper;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.DBSCANClusterer;

public class DBSCANContinuousPointGrouper
implements ContinuousPointGrouper {
    private double eps;
    private int minPts;

    public DBSCANContinuousPointGrouper(double eps, int minPts) {
        this.eps = eps;
        this.minPts = minPts;
    }

    @Override
    public List<List<ContinuousPoint>> groupContinuousPoints(List<ContinuousPoint> points) {
        DBSCANClusterer kmeansClusterer = new DBSCANClusterer(this.eps, this.minPts);
        List clusters = kmeansClusterer.cluster(points);
        return clusters.stream().map(Cluster::getPoints).collect(Collectors.toList());
    }
}

