/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.network;

import io.improbable.keanu.vertices.Vertex;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class Propagation {
    public static Set<Vertex> getVertices(Vertex vertex, Function<Vertex, Collection<Vertex>> nextVertices, Function<Vertex, Boolean> stoppingCondition, Predicate<Vertex> shouldAdd) {
        return Propagation.getVertices(Collections.singletonList(vertex), nextVertices, stoppingCondition, shouldAdd);
    }

    public static Set<Vertex> getVertices(List<Vertex> vertices, Function<Vertex, Collection<Vertex>> nextVertices, Function<Vertex, Boolean> stoppingCondition, Predicate<Vertex> shouldAdd) {
        Set nextAll = vertices.stream().flatMap(v -> ((Collection)nextVertices.apply((Vertex)v)).stream()).collect(Collectors.toSet());
        ArrayDeque stack = new ArrayDeque(nextAll);
        HashSet<Vertex> queued = new HashSet<Vertex>(vertices);
        queued.addAll(nextAll);
        HashSet<Vertex> result = new HashSet<Vertex>(vertices);
        while (!stack.isEmpty()) {
            Vertex visiting = (Vertex)stack.pop();
            if (shouldAdd.test(visiting)) {
                result.add(visiting);
            }
            if (stoppingCondition.apply(visiting).booleanValue()) continue;
            for (Vertex next : nextVertices.apply(visiting)) {
                if (queued.contains(next)) continue;
                stack.add(next);
                queued.add(next);
            }
        }
        return result;
    }

    private Propagation() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

