/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.network;

import io.improbable.keanu.algorithms.Variable;
import io.improbable.keanu.network.LambdaSection;
import io.improbable.keanu.vertices.ProbabilityCalculator;
import io.improbable.keanu.vertices.Vertex;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LambdaSectionSnapshot {
    private final Map<Vertex, LambdaSection> affectedVariablesCache = new HashMap<Vertex, LambdaSection>();

    public double logProb(Set<? extends Variable> variables) {
        Set<Vertex> lambdaSectionUnion = this.getAllVerticesAffectedBy(variables);
        return ProbabilityCalculator.calculateLogProbFor(lambdaSectionUnion);
    }

    public Set<Vertex> getAllVerticesAffectedBy(Set<? extends Variable> variables) {
        HashSet<Vertex> allAffectedVariables = new HashSet<Vertex>();
        for (Variable variable : variables) {
            if (variable instanceof Vertex) {
                LambdaSection lambdaSection = this.createVariablesAffectedByCache((Vertex)variable);
                allAffectedVariables.addAll(lambdaSection.getAllVertices());
                continue;
            }
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " is to only be used with Keanu's Vertex");
        }
        return allAffectedVariables;
    }

    private LambdaSection createVariablesAffectedByCache(Vertex latent) {
        return this.affectedVariablesCache.computeIfAbsent(latent, v -> LambdaSection.getDownstreamLambdaSection(v, true));
    }
}

