/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.network;

import io.improbable.keanu.network.Propagation;
import io.improbable.keanu.vertices.Vertex;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class LambdaSection {
    private static final Predicate<Vertex> ADD_ALL = vertex -> true;
    private static final Predicate<Vertex> PROBABILISTIC_OR_OBSERVED_ONLY = vertex -> vertex.isObserved() || vertex.isProbabilistic();
    private final Set<Vertex> allVertices;
    private final Set<Vertex> latentAndObservedVertices;

    private LambdaSection(Set<Vertex> allVertices) {
        this.allVertices = allVertices;
        this.latentAndObservedVertices = allVertices.stream().filter(PROBABILISTIC_OR_OBSERVED_ONLY).collect(Collectors.toSet());
    }

    public static LambdaSection getUpstreamLambdaSection(Vertex<?> aVertex, boolean includeNonProbabilistic) {
        return LambdaSection.getUpstreamLambdaSectionForCollection(Collections.singletonList(aVertex), includeNonProbabilistic);
    }

    public static LambdaSection getDownstreamLambdaSection(Vertex<?> aVertex, boolean includeNonProbabilistic) {
        return LambdaSection.getDownstreamLambdaSectionForCollection(Collections.singletonList(aVertex), includeNonProbabilistic);
    }

    public static LambdaSection getUpstreamLambdaSectionForCollection(List<Vertex> vertices, boolean includeNonProbabilistic) {
        Predicate<Vertex> shouldAdd = includeNonProbabilistic ? ADD_ALL : PROBABILISTIC_OR_OBSERVED_ONLY;
        Set<Vertex> upstreamVertices = Propagation.getVertices(vertices, Vertex::getParents, v -> v.isObserved() || v.isProbabilistic(), shouldAdd);
        return new LambdaSection(upstreamVertices);
    }

    public static LambdaSection getDownstreamLambdaSectionForCollection(List<Vertex> vertices, boolean includeNonProbabilistic) {
        Predicate<Vertex> shouldAdd = includeNonProbabilistic ? ADD_ALL : PROBABILISTIC_OR_OBSERVED_ONLY;
        Set<Vertex> downstreamVertices = Propagation.getVertices(vertices, Vertex::getChildren, v -> v.isObserved() || v.isProbabilistic(), shouldAdd);
        return new LambdaSection(downstreamVertices);
    }

    public Set<Vertex> getAllVertices() {
        return this.allVertices;
    }

    public Set<Vertex> getLatentAndObservedVertices() {
        return this.latentAndObservedVertices;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LambdaSection)) {
            return false;
        }
        LambdaSection other = (LambdaSection)o;
        Set<Vertex> this$allVertices = this.getAllVertices();
        Set<Vertex> other$allVertices = other.getAllVertices();
        if (this$allVertices == null ? other$allVertices != null : !((Object)this$allVertices).equals(other$allVertices)) {
            return false;
        }
        Set<Vertex> this$latentAndObservedVertices = this.getLatentAndObservedVertices();
        Set<Vertex> other$latentAndObservedVertices = other.getLatentAndObservedVertices();
        return !(this$latentAndObservedVertices == null ? other$latentAndObservedVertices != null : !((Object)this$latentAndObservedVertices).equals(other$latentAndObservedVertices));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<Vertex> $allVertices = this.getAllVertices();
        result = result * 59 + ($allVertices == null ? 43 : ((Object)$allVertices).hashCode());
        Set<Vertex> $latentAndObservedVertices = this.getLatentAndObservedVertices();
        result = result * 59 + ($latentAndObservedVertices == null ? 43 : ((Object)$latentAndObservedVertices).hashCode());
        return result;
    }

    public String toString() {
        return "LambdaSection(allVertices=" + this.getAllVertices() + ", latentAndObservedVertices=" + this.getLatentAndObservedVertices() + ")";
    }
}

