/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.model.regression;

import io.improbable.keanu.model.MAPModelFitter;
import io.improbable.keanu.model.MaximumLikelihoodModelFitter;
import io.improbable.keanu.model.ModelFitter;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.probabilistic.GaussianVertex;
import io.improbable.keanu.vertices.dbl.probabilistic.LaplaceVertex;

public enum RegressionRegularization {
    NONE{

        @Override
        public DoubleVertex getWeightsVertex(long featureCount, DoubleVertex priorOnWeightsMeans, DoubleVertex priorOnWeightsScaleParameter) {
            return (DoubleVertex)new GaussianVertex(new long[]{featureCount, 1L}, priorOnWeightsMeans, priorOnWeightsScaleParameter).setLabel("weights");
        }

        @Override
        public DoubleVertex getInterceptVertex(DoubleVertex priorOnInterceptMean, DoubleVertex priorOnInterceptScaleParameter) {
            return (DoubleVertex)new GaussianVertex(priorOnInterceptMean, priorOnInterceptScaleParameter).setLabel("intercept");
        }

        @Override
        public ModelFitter createFitterForGraph() {
            return new MaximumLikelihoodModelFitter();
        }
    }
    ,
    LASSO{

        @Override
        public DoubleVertex getWeightsVertex(long featureCount, DoubleVertex priorOnWeightsMeans, DoubleVertex priorOnWeightsScaleParameter) {
            return new LaplaceVertex(new long[]{featureCount, 1L}, priorOnWeightsMeans, priorOnWeightsScaleParameter);
        }

        @Override
        public DoubleVertex getInterceptVertex(DoubleVertex priorOnInterceptMean, DoubleVertex priorOnInterceptScaleParameter) {
            return new LaplaceVertex(priorOnInterceptMean, priorOnInterceptScaleParameter);
        }

        @Override
        public ModelFitter createFitterForGraph() {
            return new MAPModelFitter();
        }
    }
    ,
    RIDGE{

        @Override
        public DoubleVertex getWeightsVertex(long featureCount, DoubleVertex priorOnWeightsMeans, DoubleVertex priorOnWeightsScaleParameter) {
            return new GaussianVertex(new long[]{featureCount, 1L}, priorOnWeightsMeans, priorOnWeightsScaleParameter);
        }

        @Override
        public DoubleVertex getInterceptVertex(DoubleVertex priorOnInterceptMean, DoubleVertex priorOnInterceptScaleParameter) {
            return new GaussianVertex(priorOnInterceptMean, priorOnInterceptScaleParameter);
        }

        @Override
        public ModelFitter createFitterForGraph() {
            return new MAPModelFitter();
        }
    };


    public abstract DoubleVertex getWeightsVertex(long var1, DoubleVertex var3, DoubleVertex var4);

    public abstract DoubleVertex getInterceptVertex(DoubleVertex var1, DoubleVertex var2);

    public abstract ModelFitter createFitterForGraph();
}

