/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.model;

import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.tensor.dbl.DoubleTensor;

public final class ModelScoring {
    public static double coefficientOfDetermination(DoubleTensor predictedOutput, DoubleTensor trueOutput) {
        double residualSumOfSquares = (Double)trueOutput.minus(predictedOutput).pow(2.0).sum();
        double totalSumOfSquares = (Double)((DoubleTensor)trueOutput.minus(trueOutput.average())).pow(2.0).sum();
        return 1.0 - residualSumOfSquares / totalSumOfSquares;
    }

    public static double accuracy(BooleanTensor predictedOutput, BooleanTensor trueOutput) {
        return (Double)predictedOutput.elementwiseEquals(trueOutput).toDoubleMask().sum() / (double)trueOutput.getLength();
    }

    private ModelScoring() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

