/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.distributions.continuous;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.distributions.ContinuousDistribution;
import io.improbable.keanu.distributions.hyperparam.Diffs;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.dbl.DoublePlaceholderVertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;

public class Uniform
implements ContinuousDistribution {
    private final DoubleTensor xMin;
    private final DoubleTensor xMax;

    public static ContinuousDistribution withParameters(DoubleTensor xMin, DoubleTensor xMax) {
        return new Uniform(xMin, xMax);
    }

    private Uniform(DoubleTensor xMin, DoubleTensor xMax) {
        this.xMin = xMin;
        this.xMax = xMax;
    }

    @Override
    public DoubleTensor sample(long[] shape, KeanuRandom random) {
        return random.nextDouble(shape).timesInPlace(this.xMax.minus(this.xMin)).plusInPlace(this.xMin);
    }

    @Override
    public DoubleTensor logProb(DoubleTensor x) {
        DoubleTensor logOfWithinBounds = (DoubleTensor)((DoubleTensor)this.xMax.minus(this.xMin).logInPlace()).unaryMinusInPlace();
        logOfWithinBounds = logOfWithinBounds.setWithMaskInPlace(x.greaterThanOrEqualToMask(this.xMax), Double.NEGATIVE_INFINITY);
        logOfWithinBounds = logOfWithinBounds.setWithMaskInPlace(x.lessThanMask(this.xMin), Double.NEGATIVE_INFINITY);
        return logOfWithinBounds;
    }

    public static DoubleVertex logProbOutput(DoublePlaceholderVertex x, DoublePlaceholderVertex xMin, DoublePlaceholderVertex xMax) {
        DoubleVertex logOfWithinBounds = xMax.minus(xMin).log().unaryMinus();
        logOfWithinBounds = logOfWithinBounds.setWithMask(x.toGreaterThanOrEqualToMask(xMax), Double.NEGATIVE_INFINITY);
        logOfWithinBounds = logOfWithinBounds.setWithMask(x.toLessThanMask(xMin), Double.NEGATIVE_INFINITY);
        return logOfWithinBounds;
    }

    @Override
    public Diffs dLogProb(DoubleTensor x) {
        throw new UnsupportedOperationException();
    }
}

