/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.distributions.continuous;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.distributions.ContinuousDistribution;
import io.improbable.keanu.distributions.continuous.ChiSquared;
import io.improbable.keanu.distributions.hyperparam.Diffs;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import io.improbable.keanu.vertices.dbl.DoublePlaceholderVertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.operators.binary.DivisionVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.operators.unary.LogGammaVertex;
import io.improbable.keanu.vertices.intgr.IntegerPlaceholderVertex;

public class StudentT
implements ContinuousDistribution {
    private static final double HALF_LOG_PI = Math.log(Math.PI) / 2.0;
    private final IntegerTensor v;

    public static ContinuousDistribution withParameters(IntegerTensor v) {
        return new StudentT(v);
    }

    private StudentT(IntegerTensor v) {
        this.v = v;
    }

    @Override
    public DoubleTensor sample(long[] shape, KeanuRandom random) {
        DoubleTensor chi2Samples = (DoubleTensor)ChiSquared.withParameters(this.v).sample(shape, random);
        return (DoubleTensor)random.nextGaussian(shape).divInPlace(chi2Samples.divInPlace(this.v.toDouble()).sqrtInPlace());
    }

    @Override
    public DoubleTensor logProb(DoubleTensor t) {
        DoubleTensor vAsDouble = this.v.toDouble();
        DoubleTensor halfVPlusOne = (DoubleTensor)((Object)vAsDouble.plus(1.0).divInPlace(2.0));
        DoubleTensor logGammaHalfVPlusOne = (DoubleTensor)halfVPlusOne.logGamma();
        DoubleTensor logGammaHalfV = (DoubleTensor)vAsDouble.div(2.0).logGammaInPlace();
        DoubleTensor halfLogV = (DoubleTensor)((Object)((DoubleTensor)vAsDouble.log()).divInPlace(2.0));
        return (DoubleTensor)((DoubleTensor)((Object)logGammaHalfVPlusOne.minusInPlace(halfLogV).minusInPlace(HALF_LOG_PI))).minusInPlace(logGammaHalfV).minusInPlace(halfVPlusOne.timesInPlace(((DoubleTensor)((Object)t.pow(2.0).divInPlace(vAsDouble).plusInPlace(1.0))).logInPlace()));
    }

    public static DoubleVertex logProbOutput(DoublePlaceholderVertex t, IntegerPlaceholderVertex v) {
        DoubleVertex vAsDouble = v.toDouble();
        DivisionVertex halfVPlusOne = vAsDouble.plus(1.0).div(2.0);
        LogGammaVertex logGammaHalfVPlusOne = halfVPlusOne.logGamma();
        LogGammaVertex logGammaHalfV = vAsDouble.div(2.0).logGamma();
        DivisionVertex halfLogV = vAsDouble.log().div(2.0);
        return logGammaHalfVPlusOne.minus(halfLogV).minus(HALF_LOG_PI).minus(logGammaHalfV).minus(halfVPlusOne.times(t.pow(2.0).div(vAsDouble).plus(1.0).log()));
    }

    @Override
    public Diffs dLogProb(DoubleTensor t) {
        DoubleTensor vAsDouble = this.v.toDouble();
        DoubleTensor dPdt = ((DoubleTensor)t.unaryMinus()).timesInPlace(vAsDouble.plus(1.0)).divInPlace(t.pow(2.0).plusInPlace(vAsDouble));
        return new Diffs().put(Diffs.T, dPdt);
    }
}

