/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.distributions.continuous;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.distributions.ContinuousDistribution;
import io.improbable.keanu.distributions.hyperparam.Diffs;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.dbl.DoublePlaceholderVertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.operators.binary.DivisionVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.operators.binary.PowerVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.operators.unary.LogVertex;

public class Gaussian
implements ContinuousDistribution {
    public static final double SQRT_2PI = Math.sqrt(Math.PI * 2);
    public static final double LN_SQRT_2PI = Math.log(SQRT_2PI);
    private final DoubleTensor mu;
    private final DoubleTensor sigma;

    public static ContinuousDistribution withParameters(DoubleTensor mu, DoubleTensor sigma) {
        return new Gaussian(mu, sigma);
    }

    private Gaussian(DoubleTensor mu, DoubleTensor sigma) {
        this.mu = mu;
        this.sigma = sigma;
    }

    @Override
    public DoubleTensor sample(long[] shape, KeanuRandom random) {
        DoubleTensor unityGaussian = random.nextGaussian(shape);
        return unityGaussian.timesInPlace(this.sigma).plusInPlace(this.mu);
    }

    @Override
    public DoubleTensor logProb(DoubleTensor x) {
        DoubleTensor lnSigma = (DoubleTensor)this.sigma.log();
        DoubleTensor xMinusMuSquared = (DoubleTensor)x.minus(this.mu).powInPlace(2.0);
        DoubleTensor xMinusMuSquaredOver2Variance = (DoubleTensor)((Object)xMinusMuSquared.divInPlace(this.sigma.pow(2.0).timesInPlace(2.0)));
        return (DoubleTensor)((DoubleTensor)((Object)xMinusMuSquaredOver2Variance.plusInPlace(lnSigma).plusInPlace(LN_SQRT_2PI))).unaryMinusInPlace();
    }

    public static DoubleVertex logProbOutput(DoublePlaceholderVertex x, DoublePlaceholderVertex mu, DoublePlaceholderVertex sigma) {
        LogVertex lnSigma = sigma.log();
        PowerVertex xMinusMuSquared = x.minus(mu).pow(2.0);
        DivisionVertex xMinusMuSquaredOver2Variance = xMinusMuSquared.div(sigma.pow(2.0).times(2.0));
        return xMinusMuSquaredOver2Variance.plus(lnSigma).plus(LN_SQRT_2PI).unaryMinus();
    }

    @Override
    public Diffs dLogProb(DoubleTensor x) {
        DoubleTensor variance = this.sigma.pow(2.0);
        DoubleTensor xMinusMu = x.minus(this.mu);
        DoubleTensor dLogPdmu = xMinusMu.div(variance);
        DoubleTensor dLogPdx = (DoubleTensor)dLogPdmu.unaryMinus();
        DoubleTensor dLogPdsigma = (DoubleTensor)((DoubleTensor)xMinusMu.powInPlace(2.0)).divInPlace(variance.timesInPlace(this.sigma)).minusInPlace(this.sigma.reciprocal());
        return new Diffs().put(Diffs.MU, dLogPdmu).put(Diffs.SIGMA, dLogPdsigma).put(Diffs.X, dLogPdx);
    }
}

