/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.backend.keanu.compiled;

import io.improbable.keanu.algorithms.VariableReference;
import io.improbable.keanu.backend.ComputableGraph;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

class WrappedCompiledGraph
implements ComputableGraph {
    private Map<String, VariableReference> outputsByString;
    private Function<Map<String, ?>, Map<String, ?>> computeFunction;
    private Map<VariableReference, Object> cachedInputs;

    WrappedCompiledGraph(Function<Map<String, ?>, Map<String, ?>> computeFunction, List<VariableReference> outputs) {
        this.computeFunction = computeFunction;
        this.outputsByString = outputs.stream().collect(Collectors.toMap(VariableReference::toStringReference, output -> output));
        this.cachedInputs = new HashMap<VariableReference, Object>();
    }

    @Override
    public Map<VariableReference, ?> compute(Map<VariableReference, ?> inputs) {
        this.cachedInputs.putAll(inputs);
        HashMap inputsByString = new HashMap();
        for (Map.Entry<VariableReference, ?> input : inputs.entrySet()) {
            inputsByString.put(input.getKey().toStringReference(), input.getValue());
        }
        Map<String, ?> resultsByString = this.computeFunction.apply(inputsByString);
        HashMap results = new HashMap();
        for (Map.Entry<String, ?> result : resultsByString.entrySet()) {
            results.put(this.outputsByString.get(result.getKey()), result.getValue());
        }
        return results;
    }

    @Override
    public <T> T getInput(VariableReference input) {
        return (T)this.cachedInputs.get(input);
    }
}

