/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.backend.keanu.compiled;

import io.improbable.keanu.algorithms.VariableReference;
import io.improbable.keanu.backend.ComputableGraph;
import io.improbable.keanu.backend.ComputableGraphBuilder;
import io.improbable.keanu.backend.StringVariableReference;
import io.improbable.keanu.backend.keanu.compiled.KeanuCompiledVariable;
import io.improbable.keanu.backend.keanu.compiled.KeanuVertexToTensorOpMapper;
import io.improbable.keanu.backend.keanu.compiled.WrappedCompiledGraph;
import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.bool.BooleanVertex;
import io.improbable.keanu.vertices.bool.nonprobabilistic.ConstantBooleanVertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.ConstantDoubleVertex;
import io.improbable.keanu.vertices.generic.GenericTensorVertex;
import io.improbable.keanu.vertices.intgr.IntegerVertex;
import io.improbable.keanu.vertices.intgr.nonprobabilistic.ConstantIntegerVertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.joor.Reflect;

public class KeanuCompiledGraphBuilder
implements ComputableGraphBuilder<ComputableGraph> {
    private static final String PACKAGE = "io.improbable.keanu.backend.keanu";
    private static final String CLASS_NAME_PREFIX = "CompiledKeanuGraph";
    private StringBuilder computeSourceBuilder;
    private StringBuilder instanceVariableBuilder;
    private StringBuilder constructorBuilder;
    private Map<VariableReference, KeanuCompiledVariable> lookup;
    private Map<VariableReference, Object> variableValues;
    private Map<VariableReference, Object> constantValues;
    private List<VariableReference> outputs;
    private int internalOpCount = 0;
    private final String className = "CompiledKeanuGraph" + this.hashCode();

    public KeanuCompiledGraphBuilder() {
        this.computeSourceBuilder = new StringBuilder();
        this.instanceVariableBuilder = new StringBuilder();
        this.constructorBuilder = new StringBuilder();
        this.lookup = new HashMap<VariableReference, KeanuCompiledVariable>();
        this.variableValues = new HashMap<VariableReference, Object>();
        this.constantValues = new HashMap<VariableReference, Object>();
        this.outputs = new ArrayList<VariableReference>();
    }

    private void startSource(StringBuilder sb) {
        sb.append("package io.improbable.keanu.backend.keanu;\n");
        sb.append(this.importString(Collection.class));
        sb.append(this.importString(Collections.class));
        sb.append(this.importString(HashMap.class));
        sb.append(this.importString(Map.class));
        sb.append(this.importString(VariableReference.class));
        sb.append(this.importString(DoubleTensor.class));
        sb.append(this.importString(IntegerTensor.class));
        sb.append(this.importString(BooleanTensor.class));
        this.append(sb, "public final class ", this.className, " implements java.util.function.Function<Map<String, ?>, Map<String, ?>> {\n");
    }

    private String importString(Class<?> clazz) {
        return "import " + clazz.getCanonicalName() + ";\n";
    }

    private void endSource(StringBuilder sb) {
        sb.append("Map<String, Object>  results = new HashMap<>();\n");
        sb.append("\n");
        for (VariableReference out : this.outputs) {
            String name = this.lookup.get(out).getName();
            this.append(sb, "results.put(\"", out.toStringReference(), "\", ", name, ");\n");
        }
        sb.append("return results;\n");
        sb.append("}\n}\n");
    }

    @Override
    public void createConstant(Vertex visiting) {
        String type = this.getAssigmentType(visiting);
        String lookupName = visiting.getReference().toStringReference();
        String name = this.toSourceVariableName(visiting.getReference());
        this.append(this.instanceVariableBuilder, "private final ", type, " ", name, ";\n");
        this.append(this.constructorBuilder, name, " = ", "(", type, ")", "constants.get(\"", lookupName, "\");\n");
        this.lookup.put(visiting.getReference(), new KeanuCompiledVariable(name, false));
        this.constantValues.put(visiting.getReference(), visiting.getValue());
    }

    @Override
    public void createVariable(Vertex visiting) {
        String variableType = this.getAssigmentType(visiting);
        String variableName = this.toSourceVariableName(visiting.getReference());
        this.declareInput(variableType, variableName, visiting.getReference().toStringReference());
        this.lookup.put(visiting.getReference(), new KeanuCompiledVariable(variableName, false));
        this.variableValues.put(visiting.getReference(), visiting.getValue());
    }

    private void declareInput(String type, String name, String inputName) {
        this.append(this.computeSourceBuilder, "final ", type, " ", name, " = (", type, ") inputs.get(\"", inputName, "\");\n");
    }

    @Override
    public void create(Vertex visiting) {
        if (this.isConstant(visiting)) {
            this.createConstant(visiting);
            return;
        }
        KeanuVertexToTensorOpMapper.OpMapper opMapperFor = KeanuVertexToTensorOpMapper.getOpMapperFor(visiting.getClass());
        String variableType = this.getAssigmentType(visiting);
        String name = this.toSourceVariableName(visiting.getReference());
        this.append(this.computeSourceBuilder, "final ", variableType, " ", name, " = ", opMapperFor.apply(visiting, this.lookup), ";\n");
        this.lookup.put(visiting.getReference(), new KeanuCompiledVariable(name, true));
    }

    private boolean isConstant(Vertex v) {
        return v instanceof ConstantDoubleVertex || v instanceof ConstantIntegerVertex || v instanceof ConstantBooleanVertex;
    }

    private String getAssigmentType(Object v) {
        if (v instanceof DoubleVertex) {
            return DoubleTensor.class.getCanonicalName();
        }
        if (v instanceof IntegerVertex) {
            return IntegerTensor.class.getCanonicalName();
        }
        if (v instanceof BooleanVertex) {
            return BooleanTensor.class.getCanonicalName();
        }
        if (v instanceof GenericTensorVertex) {
            return Tensor.class.getCanonicalName();
        }
        return Object.class.getCanonicalName();
    }

    private String toSourceVariableName(VariableReference variableReference) {
        return "v_" + variableReference.toStringReference();
    }

    @Override
    public void registerOutput(VariableReference output) {
        this.outputs.add(output);
        this.lookup.get(output).setMutable(false);
    }

    @Override
    public Collection<VariableReference> getLatentVariables() {
        return this.variableValues.keySet();
    }

    @Override
    public VariableReference add(VariableReference left, VariableReference right) {
        String variableType = DoubleTensor.class.getCanonicalName();
        String leftName = this.lookup.get(left).getName();
        String rightName = this.lookup.get(right).getName();
        String name = "vv_" + this.internalOpCount;
        ++this.internalOpCount;
        this.append(this.computeSourceBuilder, "final ", variableType, " ", name, " = ", leftName, ".plus(", rightName + ");\n");
        StringVariableReference reference = new StringVariableReference(name);
        this.lookup.put(reference, new KeanuCompiledVariable(name, true));
        return reference;
    }

    @Override
    public void connect(Map<? extends Vertex<?>, ? extends Vertex<?>> connections) {
        connections.forEach((to, from) -> this.lookup.put(from.getReference(), this.lookup.get(to.getReference())));
    }

    public String getSource() {
        StringBuilder stringBuilder = new StringBuilder();
        this.startSource(stringBuilder);
        stringBuilder.append((CharSequence)this.instanceVariableBuilder);
        this.append(stringBuilder, "public ", this.className, "(final Map<String, ?> constants) {\n");
        stringBuilder.append((CharSequence)this.constructorBuilder);
        stringBuilder.append("}\n");
        stringBuilder.append("public Map<String, ?> apply(Map<String, ?> inputs) {\n");
        stringBuilder.append((CharSequence)this.computeSourceBuilder);
        this.endSource(stringBuilder);
        return stringBuilder.toString();
    }

    private void append(StringBuilder sb, String ... line) {
        for (String token : line) {
            sb.append(token);
        }
    }

    @Override
    public WrappedCompiledGraph build() {
        String source = this.getSource();
        return this.compile(source);
    }

    private WrappedCompiledGraph compile(String source) {
        Map<String, Object> constantsByString = this.constantValues.entrySet().stream().collect(Collectors.toMap(e -> ((VariableReference)e.getKey()).toStringReference(), Map.Entry::getValue));
        Function computeFunction = (Function)Reflect.compile((String)("io.improbable.keanu.backend.keanu." + this.className), (String)source).create(new Object[]{constantsByString}).get();
        return new WrappedCompiledGraph(computeFunction, this.outputs);
    }
}

