/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.backend.keanu;

import io.improbable.keanu.algorithms.VariableReference;
import io.improbable.keanu.backend.ComputableGraph;
import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.Vertex;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class KeanuComputableGraph
implements ComputableGraph {
    private final Map<VariableReference, Vertex> vertexLookup;
    private final List<Vertex> topoSortedGraph;
    private final Set<Vertex> outputs;

    public KeanuComputableGraph(List<Vertex> topoSortedGraph, Set<Vertex> outputs) {
        this.topoSortedGraph = new ArrayList<Vertex>(topoSortedGraph);
        this.outputs = outputs;
        this.vertexLookup = topoSortedGraph.stream().collect(Collectors.toMap(Vertex::getReference, v -> v));
    }

    @Override
    public Map<VariableReference, ?> compute(Map<VariableReference, ?> inputs) {
        for (Map.Entry<VariableReference, ?> input : inputs.entrySet()) {
            this.vertexLookup.get(input.getKey()).setValue(input.getValue());
        }
        for (int i = 0; i < this.topoSortedGraph.size(); ++i) {
            Vertex vertex = this.topoSortedGraph.get(i);
            if (vertex.isProbabilistic() || vertex.isObserved()) continue;
            vertex.setValue(((NonProbabilistic)((Object)vertex)).calculate());
        }
        return this.outputs.stream().collect(Collectors.toMap(Vertex::getReference, v -> v.getValue()));
    }

    @Override
    public <T> T getInput(VariableReference input) {
        return this.vertexLookup.get(input).getValue();
    }
}

