/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.backend;

import io.improbable.keanu.algorithms.VariableReference;
import io.improbable.keanu.backend.ComputableGraphBuilder;
import io.improbable.keanu.network.BayesianNetwork;
import io.improbable.keanu.vertices.LogProbGraph;
import io.improbable.keanu.vertices.LogProbGraphSupplier;
import io.improbable.keanu.vertices.Vertex;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ProbabilisticGraphConverter {
    public static Optional<VariableReference> convertLogProbObservation(BayesianNetwork network, ComputableGraphBuilder<?> graphBuilder) {
        return ProbabilisticGraphConverter.addLogProbCalculation(graphBuilder, network.getObservedVertices());
    }

    public static VariableReference convertLogProbPrior(BayesianNetwork network, ComputableGraphBuilder<?> graphBuilder) {
        return ProbabilisticGraphConverter.addLogProbCalculation(graphBuilder, network.getLatentVertices()).orElseThrow(() -> new IllegalArgumentException("Network must contain latent variables"));
    }

    private static Optional<VariableReference> addLogProbCalculation(ComputableGraphBuilder<?> graphBuilder, List<Vertex> probabilisticVertices) {
        List logProbOps = probabilisticVertices.stream().map(visiting -> {
            if (visiting instanceof LogProbGraphSupplier) {
                LogProbGraph logProbGraph = ((LogProbGraphSupplier)((Object)visiting)).logProbGraph();
                return ProbabilisticGraphConverter.addLogProbGraph(logProbGraph, graphBuilder);
            }
            throw new IllegalArgumentException("Vertex type " + visiting.getClass() + " logProb as a graph not supported");
        }).collect(Collectors.toList());
        Optional<VariableReference> logProbSummation = logProbOps.stream().reduce(graphBuilder::add);
        return logProbSummation;
    }

    private static VariableReference addLogProbGraph(LogProbGraph logProbGraph, ComputableGraphBuilder<?> graphBuilder) {
        graphBuilder.connect(logProbGraph.getInputs());
        graphBuilder.convert(logProbGraph.getLogProbOutput().getConnectedGraph());
        return logProbGraph.getLogProbOutput().getReference();
    }

    private ProbabilisticGraphConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

