/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.backend;

import io.improbable.keanu.algorithms.VariableReference;
import io.improbable.keanu.backend.ComputableGraph;
import io.improbable.keanu.network.LambdaSection;
import io.improbable.keanu.vertices.LogProbGraph;
import io.improbable.keanu.vertices.Probabilistic;
import io.improbable.keanu.vertices.Vertex;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;

public interface ComputableGraphBuilder<T extends ComputableGraph> {
    public void createConstant(Vertex var1);

    public void createVariable(Vertex var1);

    public void create(Vertex var1);

    public void connect(Map<? extends Vertex<?>, ? extends Vertex<?>> var1);

    public void registerOutput(VariableReference var1);

    public Collection<VariableReference> getLatentVariables();

    public VariableReference add(VariableReference var1, VariableReference var2);

    public T build();

    default public void convert(Collection<? extends Vertex> vertices, Collection<? extends Vertex> outputs) {
        Set outputsUpstreamLambdaSection = outputs.stream().flatMap(output -> LambdaSection.getUpstreamLambdaSection(output, true).getAllVertices().stream()).collect(Collectors.toSet());
        List requiredVertices = vertices.stream().filter(outputsUpstreamLambdaSection::contains).collect(Collectors.toList());
        this.convert(requiredVertices);
        outputs.stream().map(Vertex::getReference).forEach(this::registerOutput);
    }

    default public void convert(Collection<? extends Vertex> vertices) {
        Vertex visiting;
        PriorityQueue<Vertex> priorityQueue = new PriorityQueue<Vertex>(Comparator.comparing(Vertex::getId, Comparator.naturalOrder()));
        priorityQueue.addAll(vertices);
        while ((visiting = priorityQueue.poll()) != null) {
            if (visiting instanceof LogProbGraph.PlaceholderVertex) continue;
            if (visiting instanceof Probabilistic) {
                if (visiting.isObserved()) {
                    this.createConstant(visiting);
                    continue;
                }
                this.createVariable(visiting);
                continue;
            }
            this.create(visiting);
        }
    }
}

