/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.variational.optimizer.nongradient;

import io.improbable.keanu.algorithms.ProbabilisticModel;
import io.improbable.keanu.algorithms.VariableReference;
import io.improbable.keanu.algorithms.variational.optimizer.FitnessFunction;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class ProbabilityFitnessFunction
implements FitnessFunction {
    private final ProbabilisticModel probabilisticModel;
    private final BiConsumer<Map<VariableReference, DoubleTensor>, Double> onFitnessCalculation;

    public ProbabilityFitnessFunction(ProbabilisticModel probabilisticModel) {
        this(probabilisticModel, (point, fitness) -> {});
    }

    @Override
    public double getFitnessAt(Map<VariableReference, DoubleTensor> values) {
        double logProb = this.calculateFitness(this.probabilisticModel, values);
        this.onFitnessCalculation.accept(values, logProb);
        return logProb;
    }

    abstract double calculateFitness(ProbabilisticModel var1, Map<VariableReference, DoubleTensor> var2);

    public ProbabilityFitnessFunction(ProbabilisticModel probabilisticModel, BiConsumer<Map<VariableReference, DoubleTensor>, Double> onFitnessCalculation) {
        this.probabilisticModel = probabilisticModel;
        this.onFitnessCalculation = onFitnessCalculation;
    }
}

