/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.variational.optimizer.nongradient;

import io.improbable.keanu.algorithms.VariableReference;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import java.util.HashMap;
import java.util.Map;

public class OptimizerBounds {
    private Map<VariableReference, VariableBounds> variableBounds = new HashMap<VariableReference, VariableBounds>();

    public OptimizerBounds addBound(VariableReference variable, DoubleTensor min, DoubleTensor max) {
        DoubleTensor minDup = (DoubleTensor)min.duplicate();
        DoubleTensor maxDup = (DoubleTensor)max.duplicate();
        this.variableBounds.put(variable, new VariableBounds(minDup, maxDup));
        return this;
    }

    public OptimizerBounds addBound(VariableReference variable, double min, DoubleTensor max) {
        this.addBound(variable, DoubleTensor.scalar(min), max);
        return this;
    }

    public OptimizerBounds addBound(VariableReference variable, DoubleTensor min, double max) {
        this.addBound(variable, min, DoubleTensor.scalar(max));
        return this;
    }

    public OptimizerBounds addBound(VariableReference variable, double min, double max) {
        this.addBound(variable, DoubleTensor.scalar(min), DoubleTensor.scalar(max));
        return this;
    }

    public boolean hasBound(VariableReference variable) {
        return this.variableBounds.containsKey(variable);
    }

    public DoubleTensor getLower(VariableReference variable) {
        return this.variableBounds.get(variable).getMin();
    }

    public DoubleTensor getUpper(VariableReference variable) {
        return this.variableBounds.get(variable).getMax();
    }

    private static final class VariableBounds {
        private final DoubleTensor min;
        private final DoubleTensor max;

        public VariableBounds(DoubleTensor min, DoubleTensor max) {
            this.min = min;
            this.max = max;
        }

        public DoubleTensor getMin() {
            return this.min;
        }

        public DoubleTensor getMax() {
            return this.max;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariableBounds)) {
                return false;
            }
            VariableBounds other = (VariableBounds)o;
            DoubleTensor this$min = this.getMin();
            DoubleTensor other$min = other.getMin();
            if (this$min == null ? other$min != null : !this$min.equals(other$min)) {
                return false;
            }
            DoubleTensor this$max = this.getMax();
            DoubleTensor other$max = other.getMax();
            return !(this$max == null ? other$max != null : !this$max.equals(other$max));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DoubleTensor $min = this.getMin();
            result = result * 59 + ($min == null ? 43 : $min.hashCode());
            DoubleTensor $max = this.getMax();
            result = result * 59 + ($max == null ? 43 : $max.hashCode());
            return result;
        }

        public String toString() {
            return "OptimizerBounds.VariableBounds(min=" + this.getMin() + ", max=" + this.getMax() + ")";
        }
    }
}

