/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.variational.optimizer.nongradient;

import io.improbable.keanu.algorithms.ProbabilisticModel;
import io.improbable.keanu.algorithms.Variable;
import io.improbable.keanu.algorithms.VariableReference;
import io.improbable.keanu.algorithms.variational.optimizer.FitnessFunction;
import io.improbable.keanu.algorithms.variational.optimizer.OptimizedResult;
import io.improbable.keanu.algorithms.variational.optimizer.Optimizer;
import io.improbable.keanu.algorithms.variational.optimizer.ProbabilityFitness;
import io.improbable.keanu.algorithms.variational.optimizer.nongradient.BOBYQA;
import io.improbable.keanu.algorithms.variational.optimizer.nongradient.NonGradientOptimizationAlgorithm;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.util.status.StatusBar;
import io.improbable.keanu.vertices.ProbabilityCalculator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class NonGradientOptimizer
implements Optimizer {
    private final ProbabilisticModel probabilisticModel;
    private final NonGradientOptimizationAlgorithm nonGradientOptimizationAlgorithm;
    private final boolean checkInitialFitnessConditions;
    private final List<BiConsumer<Map<VariableReference, DoubleTensor>, Double>> onFitnessCalculations = new ArrayList<BiConsumer<Map<VariableReference, DoubleTensor>, Double>>();

    public static NonGradientOptimizerBuilder builder() {
        return new NonGradientOptimizerBuilder();
    }

    @Override
    public void addFitnessCalculationHandler(BiConsumer<Map<VariableReference, DoubleTensor>, Double> fitnessCalculationHandler) {
        this.onFitnessCalculations.add(fitnessCalculationHandler);
    }

    @Override
    public void removeFitnessCalculationHandler(BiConsumer<Map<VariableReference, DoubleTensor>, Double> fitnessCalculationHandler) {
        this.onFitnessCalculations.remove(fitnessCalculationHandler);
    }

    private void handleFitnessCalculation(Map<VariableReference, DoubleTensor> point, Double fitness) {
        for (BiConsumer<Map<VariableReference, DoubleTensor>, Double> fitnessCalculationHandler : this.onFitnessCalculations) {
            fitnessCalculationHandler.accept(point, fitness);
        }
    }

    private OptimizedResult optimize(ProbabilityFitness probabilityFitness) {
        return this.optimize(probabilityFitness.getFitnessFunction(this.probabilisticModel, this::handleFitnessCalculation));
    }

    private OptimizedResult optimize(FitnessFunction fitnessFunction) {
        Map<VariableReference, DoubleTensor> startingPoint;
        double initialFitness;
        StatusBar statusBar = Optimizer.createFitnessStatusBar(this);
        List<Variable> latentVariables = this.probabilisticModel.getLatentVariables();
        if (this.checkInitialFitnessConditions && ProbabilityCalculator.isImpossibleLogProb(initialFitness = fitnessFunction.getFitnessAt(startingPoint = Optimizer.convertToMapPoint(latentVariables)))) {
            throw new IllegalArgumentException("Cannot start optimizer on zero probability network");
        }
        OptimizedResult result = this.nonGradientOptimizationAlgorithm.optimize(latentVariables, fitnessFunction);
        statusBar.finish();
        return result;
    }

    @Override
    public OptimizedResult maxAPosteriori() {
        return this.optimize(ProbabilityFitness.MAP);
    }

    @Override
    public OptimizedResult maxLikelihood() {
        return this.optimize(ProbabilityFitness.MLE);
    }

    private NonGradientOptimizer(ProbabilisticModel probabilisticModel, NonGradientOptimizationAlgorithm nonGradientOptimizationAlgorithm, boolean checkInitialFitnessConditions) {
        this.probabilisticModel = probabilisticModel;
        this.nonGradientOptimizationAlgorithm = nonGradientOptimizationAlgorithm;
        this.checkInitialFitnessConditions = checkInitialFitnessConditions;
    }

    public static class NonGradientOptimizerBuilder {
        private ProbabilisticModel probabilisticModel;
        private NonGradientOptimizationAlgorithm nonGradientOptimizationAlgorithm = BOBYQA.builder().build();
        private boolean checkInitialFitnessConditions;

        public NonGradientOptimizerBuilder probabilisticModel(ProbabilisticModel probabilisticModel) {
            this.probabilisticModel = probabilisticModel;
            return this;
        }

        public NonGradientOptimizerBuilder algorithm(NonGradientOptimizationAlgorithm nonGradientOptimizationAlgorithm) {
            this.nonGradientOptimizationAlgorithm = nonGradientOptimizationAlgorithm;
            return this;
        }

        public NonGradientOptimizerBuilder checkInitialFitnessConditions(boolean check) {
            this.checkInitialFitnessConditions = check;
            return this;
        }

        public NonGradientOptimizer build() {
            if (this.probabilisticModel == null) {
                throw new IllegalStateException("Cannot build optimizer without specifying network to optimize.");
            }
            return new NonGradientOptimizer(this.probabilisticModel, this.nonGradientOptimizationAlgorithm, this.checkInitialFitnessConditions);
        }

        public String toString() {
            return "NonGradientOptimizer.NonGradientOptimizerBuilder(probabilisticModel=" + this.probabilisticModel + ", nonGradientOptimizationAlgorithm=" + this.nonGradientOptimizationAlgorithm + ", checkInitialFitnessConditions=" + this.checkInitialFitnessConditions + ")";
        }
    }
}

