/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.variational.optimizer.nongradient;

import io.improbable.keanu.algorithms.Variable;
import io.improbable.keanu.algorithms.variational.optimizer.nongradient.OptimizerBounds;
import io.improbable.keanu.tensor.TensorShape;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.optim.SimpleBounds;

class ApacheMathSimpleBoundsCalculator {
    private final double boundsRange;
    private final OptimizerBounds optimizerBounds;

    SimpleBounds getBounds(List<? extends Variable> latentVariables, double[] startPoint) {
        ArrayList<Double> minBounds = new ArrayList<Double>();
        ArrayList<Double> maxBounds = new ArrayList<Double>();
        for (Variable variable : latentVariables) {
            if (this.optimizerBounds.hasBound(variable.getReference())) {
                this.validateBoundsForVariable(variable);
                this.addBoundsForVariable(variable, minBounds, maxBounds);
                continue;
            }
            int length = TensorShape.getLengthAsInt(variable.getShape());
            int startIndex = minBounds.size();
            for (int i = 0; i < length; ++i) {
                minBounds.add(startPoint[i + startIndex] - this.boundsRange);
                maxBounds.add(startPoint[i + startIndex] + this.boundsRange);
            }
        }
        return new SimpleBounds(minBounds.stream().mapToDouble(d -> d).toArray(), maxBounds.stream().mapToDouble(d -> d).toArray());
    }

    private void addBoundsForVariable(Variable variable, List<Double> minBounds, List<Double> maxBounds) {
        DoubleTensor lowerBound = this.optimizerBounds.getLower(variable.getReference());
        DoubleTensor upperBound = this.optimizerBounds.getUpper(variable.getReference());
        if (lowerBound.isScalar()) {
            minBounds.addAll(DoubleTensor.create((double)((Double)lowerBound.scalar()), variable.getShape()).asFlatList());
        } else {
            minBounds.addAll(lowerBound.asFlatList());
        }
        if (upperBound.isScalar()) {
            maxBounds.addAll(DoubleTensor.create((double)((Double)upperBound.scalar()), variable.getShape()).asFlatList());
        } else {
            maxBounds.addAll(upperBound.asFlatList());
        }
    }

    private void validateBoundsForVariable(Variable variable) {
        if (!this.optimizerBounds.getLower(variable.getReference()).isScalar() && !Arrays.equals(variable.getShape(), this.optimizerBounds.getLower(variable.getReference()).getShape())) {
            throw new IllegalArgumentException("Lower bounds shape does not match variable shape");
        }
        if (!this.optimizerBounds.getUpper(variable.getReference()).isScalar() && !Arrays.equals(variable.getShape(), this.optimizerBounds.getUpper(variable.getReference()).getShape())) {
            throw new IllegalArgumentException("Upper bounds shape does not match variable shape");
        }
    }

    public ApacheMathSimpleBoundsCalculator(double boundsRange, OptimizerBounds optimizerBounds) {
        this.boundsRange = boundsRange;
        this.optimizerBounds = optimizerBounds;
    }
}

