/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.variational.optimizer.gradient;

import io.improbable.keanu.algorithms.Variable;
import io.improbable.keanu.algorithms.VariableReference;
import io.improbable.keanu.algorithms.variational.optimizer.FitnessFunctionGradient;
import io.improbable.keanu.algorithms.variational.optimizer.Optimizer;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;

public class ApacheFitnessFunctionGradientAdapter
implements MultivariateVectorFunction {
    private final FitnessFunctionGradient fitnessFunctionGradient;
    private final List<? extends Variable> latentVariables;

    public double[] value(double[] point) {
        Map<VariableReference, DoubleTensor> values = Optimizer.convertFromPoint(point, this.latentVariables);
        Map<? extends VariableReference, DoubleTensor> diffs = this.fitnessFunctionGradient.getGradientsAt(values);
        return ApacheFitnessFunctionGradientAdapter.alignGradientsToAppropriateIndex(diffs, this.latentVariables);
    }

    private static double[] alignGradientsToAppropriateIndex(Map<? extends VariableReference, DoubleTensor> diffs, List<? extends Variable> latentVariables) {
        ArrayList<DoubleTensor> tensors = new ArrayList<DoubleTensor>();
        for (Variable variable : latentVariables) {
            DoubleTensor tensor = diffs.get(variable.getReference());
            if (tensor != null) {
                tensors.add(tensor);
                continue;
            }
            tensors.add(DoubleTensor.zeros(variable.getShape()));
        }
        return ApacheFitnessFunctionGradientAdapter.flattenAll(tensors);
    }

    private static double[] flattenAll(List<DoubleTensor> tensors) {
        int totalLatentDimensions = 0;
        for (DoubleTensor tensor : tensors) {
            totalLatentDimensions = (int)((long)totalLatentDimensions + tensor.getLength());
        }
        double[] gradient = new double[totalLatentDimensions];
        int fillPointer = 0;
        for (DoubleTensor tensor : tensors) {
            double[] values = tensor.asFlatDoubleArray();
            System.arraycopy(values, 0, gradient, fillPointer, values.length);
            fillPointer += values.length;
        }
        return gradient;
    }

    public ApacheFitnessFunctionGradientAdapter(FitnessFunctionGradient fitnessFunctionGradient, List<? extends Variable> latentVariables) {
        this.fitnessFunctionGradient = fitnessFunctionGradient;
        this.latentVariables = latentVariables;
    }
}

