/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.variational.optimizer;

import io.improbable.keanu.algorithms.variational.optimizer.ConvergenceChecker;
import io.improbable.keanu.tensor.dbl.DoubleTensor;

public class RelativeConvergenceChecker
implements ConvergenceChecker {
    private final ConvergenceChecker.Norm normStrategy;
    private final double threshold;
    private final double epsilon;

    public RelativeConvergenceChecker(ConvergenceChecker.Norm normStrategy, double threshold) {
        this(normStrategy, threshold, 1.0E-6);
    }

    @Override
    public final boolean hasConverged(DoubleTensor[] position, DoubleTensor[] nextPosition) {
        DoubleTensor[] delta = this.relativeDelta(position, nextPosition, this.epsilon);
        return this.normStrategy.calculate(delta) < this.threshold;
    }

    private DoubleTensor[] relativeDelta(DoubleTensor[] a, DoubleTensor[] b, double epsilon) {
        DoubleTensor[] relative = new DoubleTensor[a.length];
        for (int i = 0; i < a.length; ++i) {
            relative[i] = ((DoubleTensor)a[i].minus(b[i]).abs()).plus(epsilon).div(((DoubleTensor)a[i].abs()).plus(epsilon));
        }
        return relative;
    }

    public RelativeConvergenceChecker(ConvergenceChecker.Norm normStrategy, double threshold, double epsilon) {
        this.normStrategy = normStrategy;
        this.threshold = threshold;
        this.epsilon = epsilon;
    }
}

