/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.variational.optimizer;

import io.improbable.keanu.algorithms.variational.optimizer.AbsoluteConvergenceChecker;
import io.improbable.keanu.algorithms.variational.optimizer.RelativeConvergenceChecker;
import io.improbable.keanu.tensor.dbl.DoubleTensor;

public interface ConvergenceChecker {
    public boolean hasConverged(DoubleTensor[] var1, DoubleTensor[] var2);

    public static ConvergenceChecker absoluteChecker(double threshold) {
        return ConvergenceChecker.absoluteChecker(Norm.MAX, threshold);
    }

    public static ConvergenceChecker absoluteChecker(Norm norm, double threshold) {
        return new AbsoluteConvergenceChecker(norm, threshold);
    }

    public static ConvergenceChecker relativeChecker(double threshold) {
        return ConvergenceChecker.relativeChecker(Norm.MAX, threshold);
    }

    public static ConvergenceChecker relativeChecker(Norm norm, double threshold) {
        return new RelativeConvergenceChecker(norm, threshold);
    }

    public static enum Norm {
        L2{

            @Override
            double calculate(DoubleTensor[] a) {
                double magPow2 = 0.0;
                for (int i = 0; i < a.length; ++i) {
                    magPow2 += ((Double)a[i].pow(2.0).sum()).doubleValue();
                }
                return Math.sqrt(magPow2);
            }
        }
        ,
        MAX{

            @Override
            double calculate(DoubleTensor[] a) {
                double max = -1.7976931348623157E308;
                for (int i = 0; i < a.length; ++i) {
                    max = Math.max(max, (Double)a[i].max());
                }
                return max;
            }
        };


        abstract double calculate(DoubleTensor[] var1);
    }
}

