/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.statistics;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;

public final class Autocorrelation {
    private static final FastFourierTransformer ffTransformer = new FastFourierTransformer(DftNormalization.STANDARD);

    public static double[] calculate(double[] samples) {
        double[] acovResult = Autocorrelation.autocovariance(samples);
        double variance = acovResult[0];
        double[] autocorr = Arrays.stream(acovResult).map(x -> x / variance).toArray();
        return autocorr;
    }

    private static double[] autocovariance(double[] samples) {
        int length = samples.length;
        double[] demeanPaddedWithZeros = Autocorrelation.calculatePaddedDemean(samples);
        Complex[] ifft = Autocorrelation.fftCrossCorrelationWithSelf(demeanPaddedWithZeros);
        double[] realParts = Autocorrelation.getRealPartsAndTruncate(ifft, length);
        double[] realPartsDivN = Arrays.stream(realParts).map(x -> x / (double)length).toArray();
        return realPartsDivN;
    }

    private static double[] calculatePaddedDemean(double[] samples) {
        double[] demean = Autocorrelation.demean(samples);
        int fftSize = Autocorrelation.nextPowerOfTwo(2 * samples.length + 1);
        return Arrays.copyOf(demean, fftSize);
    }

    private static double[] demean(double[] samples) {
        double mean = Arrays.stream(samples).average().orElseThrow(NoSuchElementException::new);
        return Arrays.stream(samples).map(x -> x - mean).toArray();
    }

    private static int nextPowerOfTwo(int x) {
        int highestOneBit = Integer.highestOneBit(x);
        return x == highestOneBit ? x : highestOneBit << 1;
    }

    private static Complex[] fftCrossCorrelationWithSelf(double[] values) {
        Complex[] fftData = ffTransformer.transform(values, TransformType.FORWARD);
        Complex[] fftMultipliedWithConj = Autocorrelation.multiplyWithConjugateInPlace(fftData);
        Complex[] ifft = ffTransformer.transform(fftMultipliedWithConj, TransformType.INVERSE);
        return ifft;
    }

    private static Complex[] multiplyWithConjugateInPlace(Complex[] complexNumbers) {
        for (int i = 0; i < complexNumbers.length; ++i) {
            complexNumbers[i] = complexNumbers[i].multiply(complexNumbers[i].conjugate());
        }
        return complexNumbers;
    }

    private static double[] getRealPartsAndTruncate(Complex[] complexNumbers, int newLength) {
        double[] reals = new double[newLength];
        for (int i = 0; i < newLength; ++i) {
            reals[i] = complexNumbers[i].getReal();
        }
        return reals;
    }

    private Autocorrelation() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

