/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.particlefiltering;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.algorithms.particlefiltering.ParticleFilter;
import io.improbable.keanu.vertices.Vertex;
import java.util.Collection;

public class ParticleFilterBuilder {
    private Collection<? extends Vertex> vertices;
    private int numParticles = 1000;
    private int resamplingCycles = 3;
    private double resamplingProportion = 0.5;
    private KeanuRandom random = KeanuRandom.getDefaultRandom();

    public ParticleFilterBuilder(Collection<? extends Vertex> vertices) {
        this.vertices = vertices;
    }

    public ParticleFilterBuilder withNumParticles(int numParticles) {
        this.numParticles = numParticles;
        return this;
    }

    public ParticleFilterBuilder withResamplingCycles(int resamplingCycles) {
        this.resamplingCycles = resamplingCycles;
        return this;
    }

    public ParticleFilterBuilder withResamplingProportion(double resamplingProportion) {
        this.resamplingProportion = resamplingProportion;
        return this;
    }

    public ParticleFilterBuilder withRandom(KeanuRandom random) {
        this.random = random;
        return this;
    }

    public ParticleFilter build() {
        return new ParticleFilter(this.vertices, this.numParticles, this.resamplingCycles, this.resamplingProportion, this.random);
    }
}

