/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.mcmc.proposal;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.algorithms.Variable;
import io.improbable.keanu.algorithms.mcmc.proposal.Proposal;
import io.improbable.keanu.vertices.Probabilistic;
import java.util.Set;

public interface ProposalDistribution {
    public Proposal getProposal(Set<? extends Variable> var1, KeanuRandom var2);

    public <T> double logProb(Probabilistic<T> var1, T var2, T var3);

    default public double logProbAtFromGivenTo(Proposal proposal) {
        double sumLogProb = 0.0;
        for (Variable v : proposal.getVariablesWithProposal()) {
            sumLogProb += this.logProb((Probabilistic)((Object)v), proposal.getProposalFrom(v), proposal.getProposalTo(v));
        }
        return sumLogProb;
    }

    default public double logProbAtToGivenFrom(Proposal proposal) {
        double sumLogProb = 0.0;
        for (Variable v : proposal.getVariablesWithProposal()) {
            sumLogProb += this.logProb((Probabilistic)((Object)v), proposal.getProposalTo(v), proposal.getProposalFrom(v));
        }
        return sumLogProb;
    }

    public void onProposalRejected();
}

