/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.mcmc.proposal;

import com.google.common.collect.Maps;
import io.improbable.keanu.algorithms.Variable;
import io.improbable.keanu.algorithms.VariableReference;
import io.improbable.keanu.algorithms.mcmc.proposal.Proposal;
import io.improbable.keanu.algorithms.mcmc.proposal.ProposalListener;
import java.util.Map;

public class AcceptanceRateTracker
implements ProposalListener {
    private Map<VariableReference, Counter> numApplied = Maps.newHashMap();
    private Map<VariableReference, Counter> numRejected = Maps.newHashMap();

    @Override
    public void onProposalCreated(Proposal proposal) {
        for (Variable variable : proposal.getVariablesWithProposal()) {
            this.numApplied.computeIfAbsent(variable.getReference(), i -> new Counter()).increment();
        }
    }

    @Override
    public void onProposalRejected(Proposal proposal) {
        for (Variable variable : proposal.getVariablesWithProposal()) {
            this.numRejected.computeIfAbsent(variable.getReference(), i -> new Counter()).increment();
        }
    }

    public double getAcceptanceRate(VariableReference variableReference) {
        if (!this.numApplied.keySet().contains(variableReference)) {
            throw new IllegalStateException("No proposals have been registered for " + variableReference);
        }
        return 1.0 - (double)this.numRejected.getOrDefault(variableReference, new Counter()).getValue() / (double)this.numApplied.get(variableReference).getValue();
    }

    private class Counter {
        private int count;

        private Counter() {
        }

        int getValue() {
            return this.count;
        }

        int increment() {
            return this.count++;
        }
    }
}

