/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.mcmc.nuts;

import io.improbable.keanu.algorithms.VariableReference;
import io.improbable.keanu.tensor.NumberTensor;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import java.util.HashMap;
import java.util.Map;

public class VariableValues {
    private VariableValues() {
    }

    public static double dotProduct(Map<? extends VariableReference, DoubleTensor> left, Map<? extends VariableReference, DoubleTensor> right) {
        double dotProduct = 0.0;
        for (VariableReference variableReference : left.keySet()) {
            dotProduct += ((Double)((DoubleTensor)left.get(variableReference).times((NumberTensor)right.get(variableReference))).sum()).doubleValue();
        }
        return dotProduct;
    }

    public static Map<VariableReference, DoubleTensor> pow(Map<VariableReference, DoubleTensor> values, double exponent) {
        HashMap<VariableReference, DoubleTensor> result = new HashMap<VariableReference, DoubleTensor>();
        for (VariableReference v : values.keySet()) {
            result.put(v, values.get(v).pow(exponent));
        }
        return result;
    }

    public static Map<VariableReference, DoubleTensor> divide(Map<VariableReference, DoubleTensor> left, double right) {
        HashMap<VariableReference, DoubleTensor> result = new HashMap<VariableReference, DoubleTensor>();
        for (VariableReference v : left.keySet()) {
            result.put(v, left.get(v).div(right));
        }
        return result;
    }

    public static Map<VariableReference, DoubleTensor> times(Map<VariableReference, DoubleTensor> left, double right) {
        HashMap<VariableReference, DoubleTensor> result = new HashMap<VariableReference, DoubleTensor>();
        for (VariableReference v : left.keySet()) {
            result.put(v, left.get(v).times(right));
        }
        return result;
    }

    public static Map<VariableReference, DoubleTensor> times(Map<VariableReference, DoubleTensor> left, Map<VariableReference, DoubleTensor> right) {
        HashMap<VariableReference, DoubleTensor> result = new HashMap<VariableReference, DoubleTensor>();
        for (VariableReference v : left.keySet()) {
            result.put(v, (DoubleTensor)left.get(v).times((NumberTensor)right.get(v)));
        }
        return result;
    }

    public static Map<VariableReference, DoubleTensor> add(Map<VariableReference, DoubleTensor> left, Map<VariableReference, DoubleTensor> right) {
        HashMap<VariableReference, DoubleTensor> result = new HashMap<VariableReference, DoubleTensor>();
        for (VariableReference v : left.keySet()) {
            result.put(v, (DoubleTensor)left.get(v).plus((NumberTensor)right.get(v)));
        }
        return result;
    }

    public static Map<VariableReference, DoubleTensor> withShape(double value, Map<VariableReference, DoubleTensor> shapeLike) {
        HashMap<VariableReference, DoubleTensor> result = new HashMap<VariableReference, DoubleTensor>();
        for (VariableReference v : shapeLike.keySet()) {
            result.put(v, DoubleTensor.create(value, shapeLike.get(v).getShape()));
        }
        return result;
    }

    public static Map<VariableReference, DoubleTensor> zeros(Map<VariableReference, DoubleTensor> shapeLike) {
        return VariableValues.withShape(0.0, shapeLike);
    }

    public static Map<VariableReference, DoubleTensor> ones(Map<VariableReference, DoubleTensor> shapeLike) {
        return VariableValues.withShape(1.0, shapeLike);
    }
}

