/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.mcmc.nuts;

import io.improbable.keanu.algorithms.VariableReference;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import java.util.Map;

public final class Proposal {
    private final Map<VariableReference, DoubleTensor> position;
    private final Map<? extends VariableReference, DoubleTensor> gradient;
    private final Map<VariableReference, ?> sample;
    private final double logProb;

    public Proposal(Map<VariableReference, DoubleTensor> position, Map<? extends VariableReference, DoubleTensor> gradient, Map<VariableReference, ?> sample, double logProb) {
        this.position = position;
        this.gradient = gradient;
        this.sample = sample;
        this.logProb = logProb;
    }

    public Map<VariableReference, DoubleTensor> getPosition() {
        return this.position;
    }

    public Map<? extends VariableReference, DoubleTensor> getGradient() {
        return this.gradient;
    }

    public Map<VariableReference, ?> getSample() {
        return this.sample;
    }

    public double getLogProb() {
        return this.logProb;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Proposal)) {
            return false;
        }
        Proposal other = (Proposal)o;
        Map<VariableReference, DoubleTensor> this$position = this.getPosition();
        Map<VariableReference, DoubleTensor> other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        Map<? extends VariableReference, DoubleTensor> this$gradient = this.getGradient();
        Map<? extends VariableReference, DoubleTensor> other$gradient = other.getGradient();
        if (this$gradient == null ? other$gradient != null : !((Object)this$gradient).equals(other$gradient)) {
            return false;
        }
        Map<VariableReference, ?> this$sample = this.getSample();
        Map<VariableReference, ?> other$sample = other.getSample();
        if (this$sample == null ? other$sample != null : !((Object)this$sample).equals(other$sample)) {
            return false;
        }
        return Double.compare(this.getLogProb(), other.getLogProb()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<VariableReference, DoubleTensor> $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        Map<? extends VariableReference, DoubleTensor> $gradient = this.getGradient();
        result = result * 59 + ($gradient == null ? 43 : ((Object)$gradient).hashCode());
        Map<VariableReference, ?> $sample = this.getSample();
        result = result * 59 + ($sample == null ? 43 : ((Object)$sample).hashCode());
        long $logProb = Double.doubleToLongBits(this.getLogProb());
        result = result * 59 + (int)($logProb >>> 32 ^ $logProb);
        return result;
    }

    public String toString() {
        return "Proposal(position=" + this.getPosition() + ", gradient=" + this.getGradient() + ", sample=" + this.getSample() + ", logProb=" + this.getLogProb() + ")";
    }
}

