/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.mcmc.nuts;

import io.improbable.keanu.algorithms.VariableReference;
import io.improbable.keanu.algorithms.mcmc.nuts.Potential;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import java.util.Map;

public final class LeapfrogState {
    private final Map<VariableReference, DoubleTensor> position;
    private final Map<VariableReference, DoubleTensor> momentum;
    private final Map<VariableReference, DoubleTensor> velocity;
    private final Map<? extends VariableReference, DoubleTensor> gradient;
    private final double kineticEnergy;
    private final double logProb;
    private final double energy;

    public LeapfrogState(Map<VariableReference, DoubleTensor> position, Map<VariableReference, DoubleTensor> momentum, Map<? extends VariableReference, DoubleTensor> gradient, double logProb, Potential potential) {
        this.position = position;
        this.momentum = momentum;
        this.velocity = potential.getVelocity(momentum);
        this.gradient = gradient;
        this.kineticEnergy = potential.getKineticEnergy(momentum, this.velocity);
        this.energy = this.kineticEnergy - logProb;
        this.logProb = logProb;
    }

    public Map<VariableReference, DoubleTensor> getPosition() {
        return this.position;
    }

    public Map<VariableReference, DoubleTensor> getMomentum() {
        return this.momentum;
    }

    public Map<VariableReference, DoubleTensor> getVelocity() {
        return this.velocity;
    }

    public Map<? extends VariableReference, DoubleTensor> getGradient() {
        return this.gradient;
    }

    public double getKineticEnergy() {
        return this.kineticEnergy;
    }

    public double getLogProb() {
        return this.logProb;
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeapfrogState)) {
            return false;
        }
        LeapfrogState other = (LeapfrogState)o;
        Map<VariableReference, DoubleTensor> this$position = this.getPosition();
        Map<VariableReference, DoubleTensor> other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        Map<VariableReference, DoubleTensor> this$momentum = this.getMomentum();
        Map<VariableReference, DoubleTensor> other$momentum = other.getMomentum();
        if (this$momentum == null ? other$momentum != null : !((Object)this$momentum).equals(other$momentum)) {
            return false;
        }
        Map<VariableReference, DoubleTensor> this$velocity = this.getVelocity();
        Map<VariableReference, DoubleTensor> other$velocity = other.getVelocity();
        if (this$velocity == null ? other$velocity != null : !((Object)this$velocity).equals(other$velocity)) {
            return false;
        }
        Map<? extends VariableReference, DoubleTensor> this$gradient = this.getGradient();
        Map<? extends VariableReference, DoubleTensor> other$gradient = other.getGradient();
        if (this$gradient == null ? other$gradient != null : !((Object)this$gradient).equals(other$gradient)) {
            return false;
        }
        if (Double.compare(this.getKineticEnergy(), other.getKineticEnergy()) != 0) {
            return false;
        }
        if (Double.compare(this.getLogProb(), other.getLogProb()) != 0) {
            return false;
        }
        return Double.compare(this.getEnergy(), other.getEnergy()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<VariableReference, DoubleTensor> $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        Map<VariableReference, DoubleTensor> $momentum = this.getMomentum();
        result = result * 59 + ($momentum == null ? 43 : ((Object)$momentum).hashCode());
        Map<VariableReference, DoubleTensor> $velocity = this.getVelocity();
        result = result * 59 + ($velocity == null ? 43 : ((Object)$velocity).hashCode());
        Map<? extends VariableReference, DoubleTensor> $gradient = this.getGradient();
        result = result * 59 + ($gradient == null ? 43 : ((Object)$gradient).hashCode());
        long $kineticEnergy = Double.doubleToLongBits(this.getKineticEnergy());
        result = result * 59 + (int)($kineticEnergy >>> 32 ^ $kineticEnergy);
        long $logProb = Double.doubleToLongBits(this.getLogProb());
        result = result * 59 + (int)($logProb >>> 32 ^ $logProb);
        long $energy = Double.doubleToLongBits(this.getEnergy());
        result = result * 59 + (int)($energy >>> 32 ^ $energy);
        return result;
    }

    public String toString() {
        return "LeapfrogState(position=" + this.getPosition() + ", momentum=" + this.getMomentum() + ", velocity=" + this.getVelocity() + ", gradient=" + this.getGradient() + ", kineticEnergy=" + this.getKineticEnergy() + ", logProb=" + this.getLogProb() + ", energy=" + this.getEnergy() + ")";
    }

    public LeapfrogState(Map<VariableReference, DoubleTensor> position, Map<VariableReference, DoubleTensor> momentum, Map<VariableReference, DoubleTensor> velocity, Map<? extends VariableReference, DoubleTensor> gradient, double kineticEnergy, double logProb, double energy) {
        this.position = position;
        this.momentum = momentum;
        this.velocity = velocity;
        this.gradient = gradient;
        this.kineticEnergy = kineticEnergy;
        this.logProb = logProb;
        this.energy = energy;
    }
}

