/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.mcmc;

import io.improbable.keanu.algorithms.Variable;
import io.improbable.keanu.algorithms.graphtraversal.VertexValuePropagation;
import io.improbable.keanu.algorithms.mcmc.ProposalRejectionStrategy;
import io.improbable.keanu.algorithms.mcmc.proposal.Proposal;
import io.improbable.keanu.vertices.Vertex;
import java.util.HashMap;
import java.util.Map;

public class RollbackAndCascadeOnRejection
implements ProposalRejectionStrategy {
    private Map<Vertex, Object> fromValues;

    @Override
    public void onProposalCreated(Proposal proposal) {
        this.fromValues = new HashMap<Vertex, Object>();
        for (Variable variable : proposal.getVariablesWithProposal()) {
            if (variable instanceof Vertex) {
                this.fromValues.put((Vertex)variable, variable.getValue());
                continue;
            }
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " is to only be used with Keanu's Vertex");
        }
    }

    @Override
    public void onProposalRejected(Proposal proposal) {
        for (Map.Entry<Vertex, Object> entry : this.fromValues.entrySet()) {
            Object oldValue = entry.getValue();
            Vertex vertex = entry.getKey();
            vertex.setValue(oldValue);
        }
        VertexValuePropagation.cascadeUpdate(this.fromValues.keySet());
    }
}

